/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.slf4j.helpers.Util;
import org.slf4j.impl.FileRunner;
import org.slf4j.impl.OutputChoice;
import org.slf4j.impl.utils.LogUtils;

public class SimpleLoggerConfiguration {
    private final Properties properties = new Properties();
    DateTimeFormatter dateFormatter = null;
    OutputChoice outputChoice = null;
    boolean showLogName = false;
    boolean showShortLogName = true;
    boolean levelInBrackets = false;
    boolean showThreadName = true;
    boolean showDateTime = true;
    boolean showConsole = true;
    boolean disableColor = false;
    int defaultLogLevel = 20;
    FileRunner fileRunner;

    void init() {
        this.loadProperties();
        String defaultLogLevelString = this.getStringProp("log.rootLevel", null);
        if (defaultLogLevelString != null) {
            this.defaultLogLevel = SimpleLoggerConfiguration.stringToLevel(defaultLogLevelString);
        }
        this.showLogName = this.getBoolProp("log.showLogName", this.showLogName);
        this.showShortLogName = this.getBoolProp("log.shortName", this.showShortLogName);
        this.showDateTime = this.getBoolProp("log.showDate", this.showDateTime);
        this.showThreadName = this.getBoolProp("log.showThread", this.showThreadName);
        this.showConsole = this.getBoolProp("log.console", this.showConsole);
        this.disableColor = this.getBoolProp("log.disableColor", this.disableColor);
        String dateTimeFormatStr = this.getStringProp("log.datePattern", "yyyy/MM/dd HH:mm:ss");
        this.levelInBrackets = this.getBoolProp("log.levelInBrackets", this.levelInBrackets);
        boolean cacheOutputStream = this.getBoolProp("log.cacheOutputStream", false);
        String logDir = this.getStringProp("log.dir", "");
        if (LogUtils.isEmpty(logDir)) {
            this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(logDir, cacheOutputStream);
        } else {
            String logName;
            if (logDir.endsWith(".jar")) {
                logDir = System.getenv("user.dir");
            }
            if ((logName = this.getStringProp("log.name", "")).isEmpty()) {
                logName = this.getStringProp("app.name", logName);
            }
            if (logName.isEmpty()) {
                logName = "app";
            }
            long maxSize = this.getLongProp("log.maxSize", 0x6400000L);
            String logFilePath = logDir + File.separator + logName;
            this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(logFilePath, cacheOutputStream);
            this.fileRunner = new FileRunner(logName, logDir, maxSize);
            Thread thread = new Thread(this.fileRunner);
            thread.setName("hserver-logging");
            thread.setDaemon(true);
            thread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.fileRunner.close()));
        }
        if (dateTimeFormatStr != null) {
            try {
                this.dateFormatter = DateTimeFormatter.ofPattern(dateTimeFormatStr);
            }
            catch (IllegalArgumentException e) {
                Util.report((String)"Bad date format in application; will output relative time", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        String suffix;
        String append = System.getProperty("app.env", "");
        InputStream in = AccessController.doPrivileged(() -> SimpleLoggerConfiguration.lambda$loadProperties$1(append, suffix = ".properties"));
        if (null == in) {
            in = AccessController.doPrivileged(() -> {
                String fileName = append.isEmpty() ? "app" + suffix : "app-" + append + suffix;
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(fileName);
                }
                return ClassLoader.getSystemResourceAsStream(fileName);
            });
        }
        if (null != in) {
            try {
                this.properties.load(in);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Long getLongProp(String name, long defaultValue) {
        String val = this.getStringProp(name);
        if (null == val || val.isEmpty()) {
            return defaultValue;
        }
        return Long.parseLong(val);
    }

    String getStringProp(String name, String defaultValue) {
        String prop = this.getStringProp(name);
        return prop == null ? defaultValue : prop;
    }

    private boolean getBoolProp(String name, boolean defaultValue) {
        String prop = this.getStringProp(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    private String getStringProp(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? this.properties.getProperty(name) : prop;
    }

    static int stringToLevel(String levelStr) {
        if ("trace".equalsIgnoreCase(levelStr)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(levelStr)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(levelStr)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(levelStr)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 40;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 50;
        }
        return 20;
    }

    private static OutputChoice computeOutputChoice(String logFilePath, boolean cacheOutputStream) {
        if ("System.err".equalsIgnoreCase(logFilePath)) {
            if (cacheOutputStream) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_ERR);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
        if ("System.out".equalsIgnoreCase(logFilePath)) {
            if (cacheOutputStream) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_OUT);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_OUT);
        }
        return new OutputChoice(OutputChoice.OutputChoiceType.FILE);
    }

    private static /* synthetic */ InputStream lambda$loadProperties$1(String append, String suffix) {
        String fileName = append.isEmpty() ? "application" + suffix : "application-" + append + suffix;
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        if (threadCL != null) {
            return threadCL.getResourceAsStream(fileName);
        }
        return ClassLoader.getSystemResourceAsStream(fileName);
    }
}

