/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.impl.utils.LogUtils;

public class FileRunner
implements Runnable,
Closeable {
    private BufferedWriter out;
    private File file;
    private Queue<String> logQueue = new ConcurrentLinkedQueue<String>();
    private String lastWriteDate;
    private final String logName;
    private final String logDir;
    private final long maxSize;
    private volatile boolean isRunning;

    public FileRunner(String logName, String logDir, long maxSize) {
        this.logName = logName;
        this.logDir = logDir;
        this.maxSize = maxSize;
        this.file = new File(logDir, logName + ".log");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        try {
            this.file.createNewFile();
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "utf-8"));
            this.isRunning = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.isRunning && !this.logQueue.isEmpty()) {
                this.write();
                continue;
            }
            LogUtils.sleep(100L);
        }
    }

    private void split() {
        if (this.file.length() < this.maxSize) {
            return;
        }
        String newFileName = this.logDir + "/" + this.logName + "_" + LogUtils.getDate() + "_" + LogUtils.getTime() + ".log";
        File newFile = new File(newFileName);
        boolean flag = this.file.renameTo(newFile);
        if (!flag) {
            System.err.println("backup [" + newFile.getName() + "] fail.");
        } else {
            this.file = new File(this.logDir, this.logName + ".log");
            try {
                this.file.createNewFile();
                this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "utf-8"));
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void archive() {
        String newFileName = this.logDir + "/" + this.logName + "_" + this.lastWriteDate + ".log";
        File newFile = new File(newFileName);
        boolean flag = this.file.renameTo(newFile);
        if (flag) {
            this.file = new File(this.logDir, this.logName + ".log");
            try {
                this.file.createNewFile();
                this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "utf-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void write() {
        try {
            String msg;
            if (this.logQueue.isEmpty()) {
                return;
            }
            this.split();
            if (null != this.lastWriteDate && !LogUtils.getNormalDate().equals(this.lastWriteDate)) {
                this.archive();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 1000 && null != (msg = this.logQueue.poll()); ++i) {
                stringBuilder.append(msg);
            }
            this.out.write(stringBuilder.toString());
            this.out.flush();
            this.lastWriteDate = LogUtils.getNormalDate();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void close() {
        try {
            this.isRunning = false;
            while (!this.logQueue.isEmpty()) {
                this.write();
            }
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToQueue(StringBuffer buf) {
        FileRunner fileRunner = this;
        synchronized (fileRunner) {
            String logMsg = buf.toString().replaceAll("\u001b\\[\\d+m", "") + "\r\n";
            this.logQueue.add(logMsg);
        }
    }
}

