/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.rmi.server;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.util.CmnClass;
import top.gotoeasy.framework.rmi.annotation.RemoteMethod;
import top.gotoeasy.framework.rmi.annotation.Rmi;
import top.gotoeasy.framework.rmi.server.RemoteBeanProvider;
import top.gotoeasy.framework.rmi.server.RemoteDispatcher;
import top.gotoeasy.framework.rmi.strategy.RemoteMethodNameStrategy;

public class RmiServerBuilder {
    private static final Logger log = LoggerFactory.getLogger(RemoteDispatcher.class);
    private String host;
    private int port;
    private String serviceName;
    private String rmiUrl;
    private RemoteDispatcher remote;
    private RemoteMethodNameStrategy strategy;
    private RemoteBeanProvider provider;
    private String[] packages;
    private Class<? extends Annotation> typeAnnotation;
    private Class<? extends Annotation> methodAnnotation;

    public static RmiServerBuilder get() {
        return new RmiServerBuilder();
    }

    public RmiServerBuilder server(String host, int port, String serviceName) {
        this.host = host;
        this.port = port;
        this.serviceName = serviceName;
        return this;
    }

    public RmiServerBuilder scan(String ... packages) {
        this.packages = packages;
        return this;
    }

    public RmiServerBuilder customTypeAnnotation(Class<? extends Annotation> typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
        return this;
    }

    public RmiServerBuilder customMethodAnnotation(Class<? extends Annotation> methodAnnotation) {
        this.methodAnnotation = methodAnnotation;
        return this;
    }

    public RmiServerBuilder provider(RemoteBeanProvider provider) {
        this.provider = provider;
        return this;
    }

    public RmiServerBuilder strategy(RemoteMethodNameStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public void start() {
        try {
            this.build();
            LocateRegistry.createRegistry(this.port);
            Naming.bind(this.rmiUrl, this.remote);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("RMI\u670d\u52a1\u5c31\u7eea [{}]", (Object)this.rmiUrl);
    }

    protected void build() {
        this.rmiUrl = "rmi://" + this.host + ":" + this.port + "/" + this.serviceName;
        if (this.strategy == null) {
            this.strategy = new RemoteMethodNameStrategy(){};
        }
        ArrayList list = new ArrayList();
        for (String pack : this.packages) {
            log.info("\u626b\u63cf\u5305[{}]\u4e0b\u7684\u8fdc\u7a0b\u7c7b", (Object)pack);
            list.addAll(CmnClass.getClasses((String)pack, Rmi.class));
            if (this.typeAnnotation == null) continue;
            list.addAll(CmnClass.getClasses((String)pack, this.typeAnnotation));
        }
        HashMap<String, Method> mapMethod = new HashMap<String, Method>();
        Method[] methods = null;
        Method method = null;
        String key = null;
        for (Class claz : list) {
            methods = claz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(RemoteMethod.class) && (this.methodAnnotation == null || !method.isAnnotationPresent(this.methodAnnotation))) continue;
                key = this.strategy.getName(method);
                mapMethod.put(key, method);
                log.info("\u8fdc\u7a0b\u65b9\u6cd5\u5c31\u7eea: {}", (Object)method);
            }
        }
        try {
            this.remote = new RemoteDispatcher();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.remote.setMapMethod(mapMethod);
        this.remote.setRemoteBeanProvider(this.provider);
    }
}

