/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.rmi.server;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.util.CmnClass;
import top.gotoeasy.framework.rmi.server.RemoteBeanProvider;
import top.gotoeasy.framework.rmi.server.RemoteInterface;

public class RemoteDispatcher
extends UnicastRemoteObject
implements RemoteInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RemoteDispatcher.class);
    private Map<String, Object> mapBean = new HashMap<String, Object>();
    private Map<String, Method> mapMethod;
    private RemoteBeanProvider provider;

    public void setRemoteBeanProvider(RemoteBeanProvider provider) {
        log.debug("\u8bbe\u5b9a\u8fdc\u7a0bBean\u5bf9\u8c61\u63d0\u4f9b\u8005{}", (Object)provider);
        this.provider = provider;
    }

    public void setMapMethod(Map<String, Method> mapMethod) {
        log.debug("\u8bbe\u5b9a\u8fdc\u7a0b\u65b9\u6cd5{}", mapMethod);
        this.mapMethod = mapMethod;
    }

    @Override
    public Object execute(String name, Object ... args) throws RemoteException {
        Object beanClass;
        log.debug("start [{}]({})", (Object)name, (Object)args);
        Method method = this.mapMethod.get(name);
        if (method == null) {
            log.error("\u6307\u5b9a\u65b9\u6cd5\u4e0d\u652f\u6301\u8fdc\u7a0b\u8c03\u7528\uff1a{}", (Object)name);
            throw new UnsupportedOperationException("\u6307\u5b9a\u65b9\u6cd5\u4e0d\u652f\u6301\u8fdc\u7a0b\u8c03\u7528\uff1a" + name);
        }
        Object bean = this.mapBean.get(name);
        if (bean == null) {
            beanClass = method.getDeclaringClass();
            if (this.provider == null) {
                this.provider = cls -> CmnClass.createInstance((Class)cls, null, null);
                log.debug("\u6ca1\u6709\u7279\u5b9aRemoteBeanProvider\uff0c\u6309\u65e0\u53c2\u6570\u6784\u9020\u5668\u521b\u5efa\u8fdc\u7a0bBean\u5bf9\u8c61", (Object)name, (Object)args);
            } else {
                log.debug("\u4f7f\u7528\u7279\u5b9a\u5bf9\u8c61\u63d0\u4f9b\u8005RemoteBeanProvider\u53d6\u8fdc\u7a0bBean\u5bf9\u8c61", (Object)name, (Object)args);
            }
            bean = this.provider.provide((Class<?>)beanClass);
            if (bean == null) {
                log.error("\u5bf9\u8c61\u63d0\u4f9b\u8005RemoteBeanProvider\u8fd4\u56de\u7a7a\u5bf9\u8c61\uff1a{}", (Object)name);
                throw new RemoteException("\u5bf9\u8c61\u63d0\u4f9b\u8005RemoteBeanProvider\u8fd4\u56de\u7a7a\u5bf9\u8c61\uff1a" + name);
            }
            this.mapBean.put(name, bean);
        }
        try {
            beanClass = method.invoke(bean, args);
            return beanClass;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            log.debug("end   [{}]({})", (Object)name, (Object)args);
        }
    }
}

