/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.rmi.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import top.gotoeasy.framework.rmi.client.ClientInterceptor;
import top.gotoeasy.framework.rmi.strategy.RemoteMethodNameStrategy;

public class RmiClientProxy {
    private static final Map<String, Object> mapProxy = new ConcurrentHashMap<String, Object>();
    private static final Map<String, RemoteMethodNameStrategy> mapStrategy = new ConcurrentHashMap<String, RemoteMethodNameStrategy>();

    public static <T> T getProxy(Class<T> clas, String rmiUrl) {
        return RmiClientProxy.getProxy(clas, rmiUrl, RemoteMethodNameStrategy.class);
    }

    public static <T> T getProxy(Class<T> clas, String rmiUrl, Class<? extends RemoteMethodNameStrategy> strategyClass) {
        return (T)RmiClientProxy.createProxy(clas, rmiUrl, strategyClass);
    }

    private static Object createProxy(Class<?> clas, String rmiUrl, Class<? extends RemoteMethodNameStrategy> strategyClass) {
        String strategyName = strategyClass.toGenericString();
        String key = clas.toGenericString() + rmiUrl + strategyName;
        Object obj = mapProxy.get(key);
        if (obj == null) {
            RemoteMethodNameStrategy strategy = mapStrategy.get(strategyName);
            if (strategy == null) {
                try {
                    strategy = RemoteMethodNameStrategy.class.equals(strategyClass) ? new RemoteMethodNameStrategy(){} : strategyClass.newInstance();
                    mapStrategy.put(strategyName, strategy);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(clas);
            enhancer.setCallback((Callback)new ClientInterceptor(rmiUrl, strategy));
            obj = enhancer.create();
            mapProxy.put(key, obj);
        }
        return obj;
    }
}

