/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.rmi.client;

import java.lang.reflect.Method;
import java.rmi.Naming;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.rmi.server.RemoteInterface;
import top.gotoeasy.framework.rmi.strategy.RemoteMethodNameStrategy;

public class ClientInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientInterceptor.class);
    private String rmiUrl;
    private RemoteMethodNameStrategy strategy;
    private static final Map<String, RemoteInterface> mapRemote = new HashMap<String, RemoteInterface>();

    public ClientInterceptor(String rmiUrl) {
        this.rmiUrl = rmiUrl;
        this.strategy = new RemoteMethodNameStrategy(){};
    }

    public ClientInterceptor(String rmiUrl, RemoteMethodNameStrategy strategy) {
        this.rmiUrl = rmiUrl;
        this.strategy = strategy;
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if ("#equals#getClass#hashCode#notify#notifyAll#toString#wait#".contains("#" + method.getName() + "#")) {
            return proxy.invokeSuper(target, args);
        }
        try {
            log.debug("\u8fdc\u7a0b\u8c03\u7528\u5f00\u59cb\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", (Object)method, (Object)args);
            RemoteInterface remote = mapRemote.get(this.rmiUrl);
            if (remote == null) {
                remote = (RemoteInterface)Naming.lookup(this.rmiUrl);
                mapRemote.put(this.rmiUrl, remote);
            }
            Object result = remote.execute(this.strategy.getName(method), args);
            log.debug("\u8fdc\u7a0b\u8c03\u7528\u5b8c\u6210\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", result);
            return result;
        }
        catch (Exception e) {
            mapRemote.remove(this.rmiUrl);
            log.error("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", (Object)method, (Object)args);
            throw new RuntimeException(e);
        }
    }
}

