/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.util;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.gotoeasy.framework.core.converter.ConvertUtil;

public class CmnString {
    public static boolean wildcardsMatch(String pattern, String source) {
        if (CmnString.isEmpty(pattern) || CmnString.isEmpty(source)) {
            return false;
        }
        String regStrs = "$^[]{}()|.\\";
        StringBuilder buf = new StringBuilder();
        buf.append("^");
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*') {
                buf.append(".*");
                continue;
            }
            if (ch == '?') {
                buf.append(".+");
                continue;
            }
            if (regStrs.indexOf(ch) >= 0) {
                buf.append("\\").append(ch);
                continue;
            }
            buf.append(ch);
        }
        buf.append("$");
        return Pattern.compile(buf.toString()).matcher(source).matches();
    }

    public static String nullToDefault(String str, String defaultStr) {
        return CmnString.isBlank(str) ? defaultStr : str;
    }

    public static String nullToBlank(String str) {
        return CmnString.isBlank(str) ? "" : str;
    }

    public static String left(String cs, int len) {
        if (CmnString.isBlank(cs)) {
            return "";
        }
        if (cs.length() <= len) {
            return cs;
        }
        return cs.substring(0, len);
    }

    public static String right(String cs, int len) {
        if (CmnString.isBlank(cs)) {
            return "";
        }
        if (cs.length() <= len) {
            return cs;
        }
        return cs.substring(cs.length() - len);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return CmnString.isBlank((String)obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return false;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !CmnString.isBlank(str);
    }

    public static String capitalize(String str) {
        if (CmnString.isBlank(str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String uncapitalize(String str) {
        if (CmnString.isBlank(str)) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String join(String[] strs, String separator) {
        StringBuilder buf = new StringBuilder();
        for (String str : strs) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static String format(String str, Object ... params) {
        String rs = str;
        Pattern pattern = Pattern.compile("[\\{]{1}[\\w|\\s]*[\\}]{1}");
        Matcher matcher = pattern.matcher(str);
        int i = 0;
        String tmp = null;
        while (matcher.find()) {
            if (i < params.length) {
                tmp = ConvertUtil.canConvert(params[i], String.class) ? ConvertUtil.convert(params[i], String.class) : params[i].toString();
                rs = rs.replace(matcher.group(), tmp == null ? "null" : tmp);
            }
            ++i;
        }
        return rs;
    }

    public static String repeat(String text, int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buf.append(text);
        }
        return buf.toString();
    }
}

