/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import top.gotoeasy.framework.core.util.CmnString;

public class CmnDate {
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyy_MM_dd = "yyyy-MM-dd";
    public static final String yyyyMMddHHmm = "yyyy-MM-dd HH:mm";
    public static final String yyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static Object lockObject = new Object();

    public static Date tomorrow() {
        return CmnDate.addDay(CmnDate.today(), 1);
    }

    public static boolean isToday(Date date) {
        return CmnDate.format(new Date(), yyyyMMdd).compareTo(CmnDate.format(date, yyyyMMdd)) == 0;
    }

    public static Date today() {
        return CmnDate.toDate(CmnDate.format(new Date(), yyyy_MM_dd), yyyy_MM_dd);
    }

    public static String now() {
        return CmnDate.format(new Date(), yyyyMMddHHmmss);
    }

    public static Date yesterday() {
        return CmnDate.addDay(CmnDate.today(), -1);
    }

    public static Date addDay(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, amount);
        return cal.getTime();
    }

    public static String getPreMonthFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        return CmnDate.format(cal.getTime(), "yyyy-MM") + "-01";
    }

    public static Date toDate(String strDate) {
        if (CmnString.isBlank(strDate)) {
            return null;
        }
        Date result = null;
        String strInput = strDate.replace("/", "-");
        if (result == null) {
            result = CmnDate.toDate(strInput, "yyyy-M-d");
        }
        if (result == null) {
            result = CmnDate.toDate(strInput, "yyyy-M-d HH:mm:ss");
        }
        if (result == null) {
            result = CmnDate.toDate(strInput, yyyyMMdd);
        }
        if (result == null) {
            result = CmnDate.toDate(strInput, "yyyy-M-d HH:mm");
        }
        if (result == null) {
            result = CmnDate.toDate(strInput, "yyyy-M-d HH");
        }
        if (result == null) {
            result = CmnDate.toDate(strInput, "yyyy-M-d HH:mm:ss.SSS");
        }
        return result;
    }

    public static Date toDate(String strDate, String format) {
        if (CmnString.isBlank(strDate)) {
            return null;
        }
        Date result = null;
        try {
            SimpleDateFormat sdf = CmnDate.getSimpleDateFormat(format);
            result = sdf.parse(strDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static String format(Object date, String fmt) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = CmnDate.getSimpleDateFormat(fmt);
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getSimpleDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = threadLocal.get();
        if (simpleDateFormat == null) {
            Object object = lockObject;
            synchronized (object) {
                if (simpleDateFormat == null) {
                    simpleDateFormat = new SimpleDateFormat(format);
                    simpleDateFormat.setLenient(false);
                    threadLocal.set(simpleDateFormat);
                }
            }
        }
        simpleDateFormat.applyPattern(format);
        return simpleDateFormat;
    }
}

