/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.util;

import java.beans.Transient;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.util.CmnString;

public class CmnClass {
    private static final Logger log = LoggerFactory.getLogger(CmnClass.class);

    public static List<Class<?>> getClasses(String pack, Class<? extends Annotation> typeAnnotationClass) {
        ArrayList result = new ArrayList();
        List<Class<?>> list = CmnClass.getClasses(pack);
        for (Class<?> claz : list) {
            if (!claz.isAnnotationPresent(typeAnnotationClass)) continue;
            result.add(claz);
        }
        return result;
    }

    public static List<Class<?>> getClasses(String pack) {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                log.trace("[{}]\u7c7b\u578b\u626b\u63cf", (Object)protocol);
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    CmnClass.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if ("jar".equals(protocol)) {
                    try {
                        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (name.charAt(0) == '/') {
                                name = name.substring(1);
                            }
                            if (!name.startsWith(packageDirName)) continue;
                            int idx = name.lastIndexOf(47);
                            if (idx != -1) {
                                packageName = name.substring(0, idx).replace('/', '.');
                            }
                            if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                            String className = name.substring(packageName.length() + 1, name.length() - 6);
                            try {
                                classes.add(CmnClass.loadClass(packageName + '.' + className));
                                log.info("\u627e\u5230\u7c7b[{}.{}]", (Object)packageName, (Object)className);
                            }
                            catch (Exception e) {
                                log.warn("\u6307\u5b9a\u7c7b\u627e\u4e0d\u5230\uff0c\u5ffd\u7565[{}.{}]", (Object)packageName, (Object)className);
                            }
                        }
                        continue;
                    }
                    catch (IOException e) {
                        log.warn("\u8bfb\u5199\u5f02\u5e38\uff0c\u5ffd\u7565", (Throwable)e);
                        continue;
                    }
                }
                log.warn("\u5c1a\u672a\u652f\u6301[{}]\u7c7b\u578b\u626b\u63cf", (Object)protocol);
            }
        }
        catch (IOException e) {
            log.warn("\u8bfb\u5199\u5f02\u5e38\uff0c\u5ffd\u7565", (Throwable)e);
        }
        log.trace("\u6309\u5305\u540d[{}]\u626b\u63cf\u627e\u5230\u7c7b\u5171[{}]\u4e2a", (Object)pack, (Object)classes.size());
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            String pks = packageName;
            if (CmnString.isNotBlank(pks)) {
                pks = pks + ".";
            }
            if (file.isDirectory()) {
                CmnClass.findAndAddClassesInPackageByFile(pks + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(CmnClass.loadClass(pks + className));
                log.trace("\u627e\u5230\u7c7b[{}.{}]", (Object)packageName, (Object)className);
            }
            catch (Exception e) {
                log.warn("\u6307\u5b9a\u7c7b\u627e\u4e0d\u5230\uff0c\u5ffd\u7565[{}{}]", (Object)pks, (Object)className);
            }
        }
    }

    public static Class<?> loadClass(String fullClassName) {
        try {
            Class<?> rs = Thread.currentThread().getContextClassLoader().loadClass(fullClassName);
            log.trace("\u7c7b\u88c5\u8f7d\u6210\u529f[{}]", (Object)fullClassName);
            return rs;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object createInstance(Class<?> claz, Class<?>[] argClasses, Object[] argObjs) {
        if (argClasses == null) {
            try {
                return claz.newInstance();
            }
            catch (Exception e) {
                log.error("\u6309\u65e0\u53c2\u6570\u6784\u9020\u51fd\u6570\u521b\u5efa\u5bf9\u8c61\u5931\u8d25[{}]", claz);
                throw new RuntimeException("\u6309\u65e0\u53c2\u6570\u6784\u9020\u51fd\u6570\u521b\u5efa\u5bf9\u8c61\u5931\u8d25[" + claz + "]", e);
            }
        }
        boolean bFindByClass = true;
        for (Class<?> cls : argClasses) {
            if (cls != null) continue;
            bFindByClass = false;
            break;
        }
        try {
            Constructor<?>[] constructors;
            if (bFindByClass) {
                return claz.getConstructor(argClasses).newInstance(argObjs);
            }
            for (Constructor<?> constructor : constructors = claz.getConstructors()) {
                if (constructor.getParameterCount() != argObjs.length) continue;
                try {
                    return constructor.newInstance(argObjs);
                }
                catch (Exception e) {
                    log.warn("\u5c1d\u8bd5\u521d\u59cb\u5316\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            log.error("\u6309\u6307\u5b9a\u53c2\u6570\u6784\u9020\u51fd\u6570\u521b\u5efa\u5bf9\u8c61\u5931\u8d25[{}({})]{}", new Object[]{claz, argClasses, argObjs});
            log.error("\u6309\u6307\u5b9a\u53c2\u6570\u6784\u9020\u51fd\u6570\u521b\u5efa\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6309\u6307\u5b9a\u53c2\u6570\u6784\u9020\u51fd\u6570\u521b\u5efa\u5bf9\u8c61\u5931\u8d25[" + claz + "]", e);
        }
        log.error("\u7c7b[{}]\u4e2d\u6307\u5b9a\u7684\u6784\u9020\u51fd\u6570\u627e\u4e0d\u5230{}", claz, argClasses);
        throw new RuntimeException("\u7c7b\u4e2d\u6307\u5b9a\u7684\u6784\u9020\u51fd\u6570\u627e\u4e0d\u5230");
    }

    public static boolean hasMethodWithAnnotation(Class<?> claz, Class<? extends Annotation> annotationClass) {
        Method[] methods;
        for (Method method : methods = claz.getMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getDeclaredPublicMethodNames(Class<?> claz) {
        Method[] methods;
        ArrayList<String> list = new ArrayList<String>();
        for (Method method : methods = claz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            list.add(method.getName());
        }
        return list;
    }

    public static List<Method> getPublicMethods(Class<?> claz) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = claz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            list.add(method);
        }
        return list;
    }

    public static List<Method> getSetterMethods(Class<?> claz) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Method> publicMethods = CmnClass.getPublicMethods(claz);
        for (Method method : publicMethods) {
            String name;
            if (method.getParameterCount() != 1 || method.getReturnType() != null || method.isAnnotationPresent(Transient.class) || !(name = method.getName()).startsWith("set") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            result.add(method);
        }
        return result;
    }

    public static Map<String, Method> getSetterMethodMap(Class<?> claz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        List<Method> setters = CmnClass.getGetterMethods(claz);
        for (Method method : setters) {
            result.put(CmnString.uncapitalize(method.getName().substring(3)), method);
        }
        return result;
    }

    public static Map<String, Method> getGetterMethodMap(Class<?> claz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        List<Method> getters = CmnClass.getGetterMethods(claz);
        for (Method method : getters) {
            String name = method.getName().startsWith("is") ? method.getName().substring(2) : method.getName().substring(3);
            result.put(CmnString.uncapitalize(name), method);
        }
        return result;
    }

    public static List<Method> getGetterMethods(Class<?> claz) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Method> publicMethods = CmnClass.getPublicMethods(claz);
        for (Method method : publicMethods) {
            if (method.getParameterCount() != 0 || method.getReturnType() == null || method.isAnnotationPresent(Transient.class)) continue;
            String name = method.getName();
            if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)) && method.getReturnType().equals(Boolean.class)) {
                result.add(method);
                continue;
            }
            if (!name.startsWith("get") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            result.add(method);
        }
        return result;
    }

    public static List<String> getSetterPropertyNames(Class<?> claz) {
        ArrayList<String> result = new ArrayList<String>();
        List<Method> setterMethods = CmnClass.getGetterMethods(claz);
        for (Method method : setterMethods) {
            result.add(CmnString.uncapitalize(method.getName().substring(3)));
        }
        return result;
    }

    public static List<String> getGetterPropertyNames(Class<?> claz) {
        ArrayList<String> result = new ArrayList<String>();
        List<Method> getterMethods = CmnClass.getGetterMethods(claz);
        for (Method method : getterMethods) {
            String name = method.getName().startsWith("is") ? method.getName().substring(2) : method.getName().substring(3);
            result.add(CmnString.uncapitalize(name));
        }
        return result;
    }

    public static List<String> getDeclaredPublicPropertyNames(Class<?> claz) {
        List<String> list = CmnClass.getDeclaredPublicFieldNames(claz);
        return list;
    }

    public static List<String> getDeclaredPublicFieldNames(Class<?> claz) {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields = claz.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            list.add(field.getName());
        }
        return list;
    }

    public static Map<String, Field> getDeclaredPublicFields(Class<?> claz) {
        Field[] fields;
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : fields = claz.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            map.put(field.getName(), field);
        }
        return map;
    }

    public static boolean isExtendAnnotation(Class<? extends Annotation> subAnnoClass, Class<? extends Annotation> superAnnoClass) {
        Annotation[] annotations;
        if (subAnnoClass.equals(superAnnoClass)) {
            return true;
        }
        for (Annotation anno : annotations = subAnnoClass.getAnnotations()) {
            if (anno instanceof Documented || anno instanceof Retention || anno instanceof Target) continue;
            if (superAnnoClass.isInstance(anno)) {
                return true;
            }
            if (!CmnClass.isExtendAnnotation(anno.getClass(), superAnnoClass)) continue;
            return true;
        }
        return false;
    }
}

