/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.util;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import top.gotoeasy.framework.core.converter.ConvertUtil;
import top.gotoeasy.framework.core.util.CmnClass;
import top.gotoeasy.framework.core.util.CmnString;

public class CmnBean {
    private static Map<Class<?>, Map<String, Field>> mapClassFields = null;
    private static Map<Class<?>, Map<String, Method>> mapClassSetters = null;

    public static synchronized Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields;
        if (mapClassFields == null) {
            mapClassFields = new HashMap();
        }
        if (mapClassFields.get(beanClass) != null) {
            return mapClassFields.get(beanClass);
        }
        HashMap<String, Field> mapFiled = new HashMap<String, Field>();
        for (Field field : fields = beanClass.getFields()) {
            if (field.getAnnotation(Transient.class) != null || Modifier.isFinal(field.getModifiers())) continue;
            mapFiled.put(field.getName(), field);
        }
        mapClassFields.put(beanClass, mapFiled);
        return mapFiled;
    }

    public static synchronized Map<String, Method> getSetterMap(Class<?> beanClass) {
        Method[] methods;
        if (mapClassSetters == null) {
            mapClassSetters = new HashMap();
        }
        if (mapClassSetters.get(beanClass) != null) {
            return mapClassSetters.get(beanClass);
        }
        HashMap<String, Method> mapSetter = new HashMap<String, Method>();
        for (Method method : methods = beanClass.getMethods()) {
            String name;
            Class<?>[] argCls;
            if (!"void".equals(method.getReturnType().getName()) || (argCls = method.getParameterTypes()).length != 1 || !(name = method.getName()).startsWith("set") || name.length() < 4) continue;
            name = CmnString.uncapitalize(name.substring(3));
            mapSetter.put(name, method);
        }
        mapClassSetters.put(beanClass, mapSetter);
        return mapSetter;
    }

    public static void copyFields(Object orig, Object target) {
        CmnBean.copyFields(orig, target, true);
    }

    public static void copyFields(Object orig, Object target, boolean copyNullValue) {
        try {
            Map origMap = null;
            if (orig instanceof Map) {
                origMap = (Map)orig;
            }
            Map<String, Field> mapOrigField = CmnBean.getFieldMap(orig.getClass());
            Map<String, Field> mapTargetField = CmnBean.getFieldMap(target.getClass());
            Iterator<String> it = mapTargetField.keySet().iterator();
            Object origValue = null;
            Field fieldTarget = null;
            while (it.hasNext()) {
                fieldTarget = mapTargetField.get(it.next());
                if (origMap != null) {
                    if (!origMap.containsKey(fieldTarget.getName())) continue;
                    origValue = origMap.get(fieldTarget.getName());
                    if (origValue == null) {
                        if (!copyNullValue) continue;
                        CmnBean.setFieldValue(target, fieldTarget, origValue);
                        continue;
                    }
                    if (fieldTarget.getType().equals(origValue.getClass())) {
                        CmnBean.setFieldValue(target, fieldTarget, origValue);
                        continue;
                    }
                    CmnBean.setFieldValue(target, fieldTarget, ConvertUtil.convert(origValue, fieldTarget.getType()));
                    continue;
                }
                if (!mapOrigField.containsKey(fieldTarget.getName())) continue;
                origValue = CmnBean.getFieldValue(orig, fieldTarget.getName());
                if (origValue == null) {
                    if (!copyNullValue) continue;
                    CmnBean.setFieldValue(target, fieldTarget, origValue);
                    continue;
                }
                if (fieldTarget.getType().equals(origValue.getClass())) {
                    CmnBean.setFieldValue(target, fieldTarget, origValue);
                    continue;
                }
                CmnBean.setFieldValue(target, fieldTarget, ConvertUtil.convert(origValue, fieldTarget.getType()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = CmnBean.getFieldMap(obj.getClass()).get(fieldName);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) {
        try {
            Field field = CmnBean.getFieldMap(obj.getClass()).get(fieldName);
            if (field == null) {
                return;
            }
            field.setAccessible(true);
            field.set(obj, fieldValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object target, Field targetField, Object value) {
        try {
            if (!Modifier.isPublic(targetField.getModifiers())) {
                targetField.setAccessible(true);
            }
            targetField.set(target, ConvertUtil.convert(value, targetField.getType()));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean setPropertyValue(Object target, String property, Object value) {
        if (target instanceof Map) {
            ((Map)target).put(property, value);
            return true;
        }
        Map<String, Method> methodMap = CmnBean.getSetterMap(target.getClass());
        if (methodMap.containsKey(property)) {
            Method method = methodMap.get(property);
            try {
                method.invoke(target, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        Map<String, Field> fieldMap = CmnBean.getFieldMap(target.getClass());
        if (fieldMap.containsKey(property)) {
            CmnBean.setFieldValue(target, fieldMap.get(property), value);
            return true;
        }
        return false;
    }

    public static Object getPropertyValue(Object target, String property) {
        if (target instanceof Map) {
            return ((Map)target).get(property);
        }
        Map<String, Method> mapMethod = CmnClass.getGetterMethodMap(target.getClass());
        Method method = mapMethod.get(property);
        if (method != null) {
            try {
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return CmnBean.getFieldValue(target, property);
    }
}

