/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.converter.Converter;
import top.gotoeasy.framework.core.util.CmnClass;

public class ConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(ConvertUtil.class);
    private static Map<String, Converter<?, ?>> mapConverter = new HashMap();

    public static boolean canConvert(Object orig, Class<?> toClass) {
        if (orig == null || toClass.isInstance(orig)) {
            return true;
        }
        return mapConverter.containsKey(ConvertUtil.getConvertKey(orig, toClass));
    }

    public static <T> T convert(Object orig, Class<T> toClass) {
        if (orig == null) {
            return null;
        }
        if (toClass.isInstance(orig)) {
            return (T)orig;
        }
        Converter<?, ?> converter = mapConverter.get(ConvertUtil.getConvertKey(orig, toClass));
        if (converter != null) {
            return (T)converter.convert(orig);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u4ece[" + orig.getClass() + "]\u8f6c\u6362\u5230[" + toClass + "]");
    }

    private static <T> String getConvertKey(Converter<?, ?> converter) {
        Type[] genType = converter.getClass().getGenericInterfaces();
        Type[] params = ((ParameterizedType)genType[0]).getActualTypeArguments();
        return params[0] + "#" + params[1];
    }

    private static String getConvertKey(Object orig, Class<?> toClass) {
        return orig == null ? "" : orig.getClass() + "#" + toClass;
    }

    public static void addConverter(Converter<?, ?> converter) {
        String key = ConvertUtil.getConvertKey(converter);
        if (mapConverter.containsKey(key)) {
            log.warn("\u8f6c\u6362\u5668\u91cd\u590d\uff0c[{}]\u88ab\u8986\u76d6\u4e3a[{}]", mapConverter.get(key).getClass(), converter.getClass());
        }
        mapConverter.put(ConvertUtil.getConvertKey(converter), converter);
    }

    static {
        List<Class<?>> list = CmnClass.getClasses(Converter.class.getPackage().getName());
        for (Class<?> claz : list) {
            if (claz.isInterface()) continue;
            try {
                Object obj = claz.newInstance();
                if (!(obj instanceof Converter)) continue;
                log.trace("\u6dfb\u52a0\u8f6c\u6362\u5668[{}]", claz);
                ConvertUtil.addConverter((Converter)obj);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u5668[{}]\u521d\u59cb\u5316\u5931\u8d25", claz);
            }
        }
    }
}

