/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import top.gotoeasy.framework.core.compiler.MemoryFileManager;
import top.gotoeasy.framework.core.compiler.MemorySourceInputObject;

public class MemoryJavaCompiler {
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private MemoryFileManager manager = new MemoryFileManager(this.compiler.getStandardFileManager(null, null, null));
    private DiagnosticListener<JavaFileObject> listener;

    public void compile(String className, String sourceCode) {
        MemorySourceInputObject javaFileObject = new MemorySourceInputObject(className, sourceCode);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.manager, this.getDiagnosticListener(), null, null, Arrays.asList(javaFileObject));
        Boolean ok = task.call();
        if (!Boolean.TRUE.equals(ok)) {
            throw new RuntimeException("Compile failed.");
        }
    }

    public void compile(Map<String, String> map) {
        ArrayList<MemorySourceInputObject> list = new ArrayList<MemorySourceInputObject>();
        for (String className : map.keySet()) {
            list.add(new MemorySourceInputObject(className, map.get(className)));
        }
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.manager, this.getDiagnosticListener(), null, null, list);
        Boolean ok = task.call();
        if (!Boolean.TRUE.equals(ok)) {
            throw new RuntimeException("Compile failed.");
        }
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListener() {
        if (this.listener == null) {
            this.listener = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                        System.err.println(diagnostic);
                    }
                }
            };
        }
        return this.listener;
    }
}

