/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.UUID;
import top.gotoeasy.framework.core.util.CmnString;

public class CmnFile {
    public static File getTempFile() {
        String uuid = UUID.randomUUID().toString();
        File tempFile = null;
        try {
            File dir = File.createTempFile("tmp", null).getParentFile();
            tempFile = new File(dir, uuid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tempFile;
    }

    public static void deleteFile(File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String fileName) {
        CmnFile.deleteFile(new File(fileName));
    }

    public static void deleteFile(File folder, String name) {
        try {
            File file = new File(folder, name);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String readFileText(String pathname, String encoding) {
        String string;
        File file;
        String filecodding = "UTF-8";
        if (CmnString.isNotBlank(encoding)) {
            filecodding = encoding;
        }
        if ((file = new File(pathname)).isDirectory() || !file.exists()) {
            return null;
        }
        Long length = file.length();
        byte[] content = new byte[length.intValue()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(content);
            string = new String(content, filecodding);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CmnFile.closeQuietly(in);
                throw throwable;
            }
        }
        CmnFile.closeQuietly(in);
        return string;
    }

    public static void writeFileText(String pathname, String content, String encoding) {
        String filecodding = "UTF-8";
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(pathname));
            out.write(content.getBytes(filecodding));
            out.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CmnFile.closeQuietly(out);
                throw throwable;
            }
        }
        CmnFile.closeQuietly(out);
    }
}

