/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import top.gotoeasy.framework.core.reflect.ClassScaner;
import top.gotoeasy.framework.core.reflect.MethodScaner;
import top.gotoeasy.framework.core.util.CmnString;

public class ScanBuilder {
    private List<String> listPackage = new ArrayList<String>();
    private List<Class<? extends Annotation>> listTypeAnno = new ArrayList<Class<? extends Annotation>>();
    private List<Class<? extends Annotation>> listMethodAnno = new ArrayList<Class<? extends Annotation>>();

    public static ScanBuilder get() {
        return new ScanBuilder();
    }

    public ScanBuilder packages(String ... packages) {
        for (String pack : packages) {
            String[] packs;
            for (String pkg : packs = pack.split(",")) {
                if (!CmnString.isNotBlank(pkg) || this.listPackage.contains(pkg.trim())) continue;
                this.listPackage.add(pkg.trim());
            }
        }
        return this;
    }

    public ScanBuilder packages(List<String> packages) {
        for (String pack : packages) {
            String[] packs;
            for (String pkg : packs = pack.split(",")) {
                if (!CmnString.isNotBlank(pkg) || this.listPackage.contains(pkg.trim())) continue;
                this.listPackage.add(pkg.trim());
            }
        }
        return this;
    }

    public ScanBuilder typeAnnotations(Class<? extends Annotation> ... typeAnnotations) {
        for (Class<? extends Annotation> anno : typeAnnotations) {
            if (this.listTypeAnno.contains(anno)) continue;
            this.listTypeAnno.add(anno);
        }
        return this;
    }

    public ScanBuilder typeAnnotations(List<Class<? extends Annotation>> typeAnnotations) {
        for (Class<? extends Annotation> anno : typeAnnotations) {
            if (this.listTypeAnno.contains(anno)) continue;
            this.listTypeAnno.add(anno);
        }
        return this;
    }

    public ScanBuilder methodAnnotations(Class<? extends Annotation> ... methodAnnotations) {
        for (Class<? extends Annotation> anno : methodAnnotations) {
            if (this.listMethodAnno.contains(anno)) continue;
            this.listMethodAnno.add(anno);
        }
        return this;
    }

    public List<Class<?>> getClasses() {
        HashMap map = new HashMap();
        for (String pack : this.listPackage) {
            List<Class<?>> list = ClassScaner.getClasses(pack);
            block1: for (Class<?> claz : list) {
                if (this.listTypeAnno.isEmpty()) {
                    map.put(claz, claz);
                    continue;
                }
                for (Class<? extends Annotation> anno : this.listTypeAnno) {
                    if (!claz.isAnnotationPresent(anno)) continue;
                    map.put(claz, claz);
                    continue block1;
                }
            }
        }
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        return list;
    }

    public List<Method> getMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Class<?>> classes = this.getClasses();
        for (Class<?> claz : classes) {
            List<Method> list = MethodScaner.getDeclaredPublicMethods(claz);
            block1: for (Method method : list) {
                for (Class<? extends Annotation> anno : this.listMethodAnno) {
                    if (!method.isAnnotationPresent(anno)) continue;
                    result.add(method);
                    continue block1;
                }
            }
        }
        return result;
    }
}

