/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.reflect;

import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import top.gotoeasy.framework.core.reflect.ClassScaner;
import top.gotoeasy.framework.core.util.CmnString;

public class MethodScaner {
    public static List<Method> getDeclaredPublicMethods(String ... packages) {
        LinkedHashMap<Method, Method> map = new LinkedHashMap<Method, Method>();
        for (String pack : packages) {
            List<Class<?>> classes = ClassScaner.getClasses(pack);
            for (Class<?> claz : classes) {
                List<Method> methods = MethodScaner.getDeclaredPublicMethods(claz);
                for (Method method : methods) {
                    map.put(method, method);
                }
            }
        }
        ArrayList<Method> list = new ArrayList<Method>();
        list.addAll(map.values());
        return list;
    }

    public static List<Method> getPublicMethods(Class<?> claz) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = claz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            list.add(method);
        }
        return list;
    }

    public static List<Method> getDeclaredPublicMethods(Class<?> claz) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = claz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            list.add(method);
        }
        return list;
    }

    public static List<Method> getDeclaredPublicMethods(Class<?> claz, Class<? extends Annotation> ... methodAnnotations) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        block0: for (Method method : methods = claz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            for (Class<? extends Annotation> methodAnnotation : methodAnnotations) {
                if (!method.isAnnotationPresent(methodAnnotation)) continue;
                list.add(method);
                continue block0;
            }
        }
        return list;
    }

    public static List<Method> getGetterMethods(Class<?> claz) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Method> publicMethods = MethodScaner.getPublicMethods(claz);
        for (Method method : publicMethods) {
            if (method.getParameterCount() != 0 || method.getReturnType() == null || method.isAnnotationPresent(Transient.class)) continue;
            String name = method.getName();
            if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)) && method.getReturnType().equals(Boolean.class)) {
                result.add(method);
                continue;
            }
            if (!name.startsWith("get") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            result.add(method);
        }
        return result;
    }

    public static Map<String, Method> getGetterMethodMap(Class<?> claz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        List<Method> getters = MethodScaner.getGetterMethods(claz);
        for (Method method : getters) {
            String name = method.getName().startsWith("is") ? method.getName().substring(2) : method.getName().substring(3);
            result.put(CmnString.uncapitalize(name), method);
        }
        return result;
    }

    public static List<Method> getSetterMethods(Class<?> claz) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Method> publicMethods = MethodScaner.getPublicMethods(claz);
        for (Method method : publicMethods) {
            String name;
            if (method.getParameterCount() != 1 || method.getReturnType() != null || method.isAnnotationPresent(Transient.class) || !(name = method.getName()).startsWith("set") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            result.add(method);
        }
        return result;
    }

    public static Map<String, Method> getSetterMethodMap(Class<?> claz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        List<Method> setters = MethodScaner.getGetterMethods(claz);
        for (Method method : setters) {
            result.put(CmnString.uncapitalize(method.getName().substring(3)), method);
        }
        return result;
    }
}

