/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.reflect;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.util.CmnString;

public class ClassScaner {
    private static final Logger log = LoggerFactory.getLogger(ClassScaner.class);

    public static List<Class<?>> getClasses(String pack, Class<? extends Annotation> typeAnnotation) {
        ArrayList result = new ArrayList();
        List<Class<?>> list = ClassScaner.getClasses(pack);
        for (Class<?> claz : list) {
            if (!claz.isAnnotationPresent(typeAnnotation)) continue;
            result.add(claz);
        }
        return result;
    }

    public static List<Class<?>> getClasses(String pack) {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                log.trace("[{}]\u7c7b\u578b\u626b\u63cf", (Object)protocol);
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassScaner.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if ("jar".equals(protocol)) {
                    try {
                        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (name.charAt(0) == '/') {
                                name = name.substring(1);
                            }
                            if (!name.startsWith(packageDirName)) continue;
                            int idx = name.lastIndexOf(47);
                            if (idx != -1) {
                                packageName = name.substring(0, idx).replace('/', '.');
                            }
                            if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                            String className = name.substring(packageName.length() + 1, name.length() - 6);
                            try {
                                classes.add(ClassScaner.loadClass(packageName + '.' + className));
                                log.info("\u627e\u5230\u7c7b[{}.{}]", (Object)packageName, (Object)className);
                            }
                            catch (Exception e) {
                                log.warn("\u6307\u5b9a\u7c7b\u627e\u4e0d\u5230\uff0c\u5ffd\u7565[{}.{}]", (Object)packageName, (Object)className);
                            }
                        }
                        continue;
                    }
                    catch (IOException e) {
                        log.warn("\u8bfb\u5199\u5f02\u5e38\uff0c\u5ffd\u7565", (Throwable)e);
                        continue;
                    }
                }
                log.warn("\u5c1a\u672a\u652f\u6301[{}]\u7c7b\u578b\u626b\u63cf", (Object)protocol);
            }
        }
        catch (IOException e) {
            log.warn("\u8bfb\u5199\u5f02\u5e38\uff0c\u5ffd\u7565", (Throwable)e);
        }
        log.trace("\u6309\u5305\u540d[{}]\u626b\u63cf\u627e\u5230\u7c7b\u5171[{}]\u4e2a", (Object)pack, (Object)classes.size());
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            String pks = packageName;
            if (CmnString.isNotBlank(pks)) {
                pks = pks + ".";
            }
            if (file.isDirectory()) {
                ClassScaner.findAndAddClassesInPackageByFile(pks + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(ClassScaner.loadClass(pks + className));
                log.trace("\u627e\u5230\u7c7b[{}.{}]", (Object)packageName, (Object)className);
            }
            catch (Exception e) {
                log.warn("\u6307\u5b9a\u7c7b\u627e\u4e0d\u5230\uff0c\u5ffd\u7565[{}{}]", (Object)pks, (Object)className);
            }
        }
    }

    public static Class<?> loadClass(String fullClassName) {
        try {
            Class<?> rs = Thread.currentThread().getContextClassLoader().loadClass(fullClassName);
            log.trace("\u7c7b\u88c5\u8f7d\u6210\u529f[{}]", (Object)fullClassName);
            return rs;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

