/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.config.JsConfigKeys;
import top.gotoeasy.framework.core.util.CmnResource;
import top.gotoeasy.framework.core.util.CmnString;

public class JsConfig
implements JsConfigKeys {
    private static final Logger log = LoggerFactory.getLogger(JsConfig.class);
    private List<String> files;
    private List<String> scanPackages;
    private Map<String, Map<String, Object>> beans;
    private Map<String, List<Map<String, Object>>> beanProps;
    private Map<String, Object> values;
    private ScriptEngine engine;
    private Map<String, String> classNameMap = new HashMap<String, String>();

    public JsConfig() {
        this.files = new ArrayList<String>();
        this.scanPackages = new ArrayList<String>();
        this.beans = new HashMap<String, Map<String, Object>>();
        this.beanProps = new HashMap<String, List<Map<String, Object>>>();
        this.values = new HashMap<String, Object>();
        this.engine = new ScriptEngineManager().getEngineByName("js");
        this.engine.put("jsConfig", this);
    }

    public JsConfig(String file) {
        this();
        this.loadConfigFile(file);
    }

    public String[] getScanPackages() {
        String[] ary = new String[this.scanPackages.size()];
        for (int i = 0; i < this.scanPackages.size(); ++i) {
            ary[i] = this.scanPackages.get(i);
        }
        return ary;
    }

    public List<String> getScanPackageList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.scanPackages.size(); ++i) {
            list.add(this.scanPackages.get(i));
        }
        return list;
    }

    public Map<String, Map<String, Object>> getBeans() {
        return this.beans;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Map<String, List<Map<String, Object>>> getBeanProps() {
        return this.beanProps;
    }

    public void addScanPackage(String pack) {
        log.trace("\u6dfb\u52a0\u626b\u63cf\u76ee\u6807\u5305\u540d[{}]", (Object)pack);
        if (!this.scanPackages.contains(pack)) {
            this.scanPackages.add(pack);
        }
    }

    private String convertClassName(String className) {
        if (this.classNameMap.containsKey(className)) {
            return this.classNameMap.get(className);
        }
        return className;
    }

    public void anonymousClass(Object anonymous) {
        if (anonymous == null || !(anonymous instanceof Map)) {
            return;
        }
        Map map = (Map)anonymous;
        for (String key : map.keySet()) {
            this.classNameMap.put(key, (String)map.get(key));
        }
    }

    public void addBeans(Object obj) {
        Map<String, Object> map = this.toMap(obj);
        Map bean = null;
        for (String name : map.keySet()) {
            if (this.beans.containsKey(name)) {
                log.error("Bean\u540d\u79f0[{}]\u91cd\u590d", (Object)name);
                throw new RuntimeException("Bean\u540d\u79f0[" + name + "]\u91cd\u590d");
            }
            bean = (Map)map.get(name);
            this.editClassName(bean);
            this.beans.put(name, bean);
        }
    }

    private void editClassName(Map<String, Object> map) {
        List args;
        if (CmnString.isNotBlank((String)map.get("class"))) {
            map.put("class", this.convertClassName((String)map.get("class")));
        }
        if ((args = (List)map.get("args")) != null) {
            for (Map arg : args) {
                this.editClassName(arg);
            }
        }
    }

    public void addProperties(Object obj) {
        Map<String, Object> map = this.toMap(obj);
        for (String name : map.keySet()) {
            if (!this.values.containsKey(name)) continue;
            log.error("\u5c5e\u6027\u540d\u79f0[{}]\u91cd\u590d", (Object)name);
            throw new RuntimeException("\u5c5e\u6027\u540d\u79f0[" + name + "]\u91cd\u590d");
        }
        this.values.putAll(map);
        log.trace("\u6dfb\u52a0\u7b80\u5355\u7c7b\u578b\u5c5e\u6027\u5b9a\u4e49[{}]", map);
    }

    public void loadConfigFile(String file) {
        if (this.files.contains(file)) {
            log.warn("\u914d\u7f6e\u6587\u4ef6\u91cd\u590d\uff0c\u4e0d\u505a\u91cd\u590d\u88c5\u8f7d\u5904\u7406[{}]", (Object)file);
            return;
        }
        this.files.add(file);
        log.debug("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6[{}]", (Object)file);
        try {
            this.engine.eval(CmnResource.getResourceContext("conf.js", JsConfig.class) + CmnResource.getResourceContext(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object toJavaObject(Object jsObj) {
        if (jsObj == null) {
            return null;
        }
        if (this.isScriptObjectMirror(jsObj)) {
            return this.isJsArray(jsObj) ? this.toList(jsObj) : this.toMap(jsObj);
        }
        return jsObj;
    }

    private List toList(Object jsObj) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Class<?> cls = this.getClassScriptObjectMirror();
            Method values = cls.getMethod("values", new Class[0]);
            Object vals = values.invoke(jsObj, new Object[0]);
            if (vals instanceof Collection) {
                Collection collection = (Collection)vals;
                for (Object item : collection) {
                    if (cls.isAssignableFrom(item.getClass())) {
                        list.add(this.toJavaObject(item));
                        continue;
                    }
                    list.add(item);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return list;
    }

    private Map<String, Object> toMap(Object jsObj) {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        Map mapJs = (Map)jsObj;
        Iterator iterator = mapJs.keySet().iterator();
        String key = null;
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            rs.put(key, this.toJavaObject(mapJs.get(key)));
        }
        return rs;
    }

    private boolean isJsArray(Object jsObj) {
        try {
            Class<?> cls = this.getClassScriptObjectMirror();
            if (cls.isAssignableFrom(jsObj.getClass())) {
                Method isArray = cls.getMethod("isArray", new Class[0]);
                Object result = isArray.invoke(jsObj, new Object[0]);
                return result != null && result.equals(true);
            }
        }
        catch (Exception ignored) {
            log.warn("\u4e0d\u5904\u7406\u7684\u5f02\u5e38", (Throwable)ignored);
        }
        return false;
    }

    private boolean isScriptObjectMirror(Object jsObj) {
        return this.getClassScriptObjectMirror().isAssignableFrom(jsObj.getClass());
    }

    private Class<?> getClassScriptObjectMirror() {
        try {
            return Class.forName("jdk.nashorn.api.scripting.ScriptObjectMirror");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

