/*
 * Decompiled with CFR 0.152.
 */
package top.gotoeasy.framework.core.bus.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.gotoeasy.framework.core.bus.Bus;
import top.gotoeasy.framework.core.bus.annotation.BusListener;
import top.gotoeasy.framework.core.util.Assert;

public class DefaultBus
implements Bus {
    private static final Logger log = LoggerFactory.getLogger(DefaultBus.class);
    private Map<String, List<ListenerMethod>> map = new ConcurrentHashMap<String, List<ListenerMethod>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void one(String key, Object listener) {
        List<ListenerMethod> list;
        Assert.notNull(key, "key\u5fc5\u987b\u975e\u7a7a");
        Assert.notNull(listener, "listener\u975e\u7a7a");
        List<ListenerMethod> list2 = list = this.getListenerList(key);
        synchronized (list2) {
            ListenerMethod lm = this.getListener(listener);
            list.clear();
            list.add(lm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void on(String key, Object listener) {
        List<ListenerMethod> list;
        Assert.notNull(key, "key\u5fc5\u987b\u975e\u7a7a");
        Assert.notNull(listener, "listener\u975e\u7a7a");
        List<ListenerMethod> list2 = list = this.getListenerList(key);
        synchronized (list2) {
            ListenerMethod lm = this.getListener(listener);
            if (!list.contains(lm)) {
                list.add(lm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void off(String key, Object listener) {
        List<ListenerMethod> list;
        if (key == null || listener == null) {
            return;
        }
        List<ListenerMethod> list2 = list = this.getListenerList(key);
        synchronized (list2) {
            if (list.contains(listener)) {
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void off(String key) {
        List<ListenerMethod> list;
        if (key == null) {
            return;
        }
        List<ListenerMethod> list2 = list = this.getListenerList(key);
        synchronized (list2) {
            list.clear();
        }
    }

    @Override
    public Object trigger(String key, Object ... args) {
        if (key == null) {
            return null;
        }
        List<ListenerMethod> list = this.getListenerList(key);
        boolean one = list.size() == 1;
        try {
            for (ListenerMethod lm : list) {
                Object rs = lm.method.isVarArgs() ? lm.method.invoke(lm.bean, new Object[]{args}) : lm.method.invoke(lm.bean, args);
                if (!one) continue;
                return rs;
            }
        }
        catch (Exception e) {
            log.error("key=[{}], args={}, ListenerMethod={}", new Object[]{key, args, list});
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ListenerMethod> getListenerList(String key) {
        List<ListenerMethod> list = this.map.get(key);
        if (list == null) {
            Map<String, List<ListenerMethod>> map = this.map;
            synchronized (map) {
                if (list == null) {
                    list = new ArrayList<ListenerMethod>();
                    this.map.put(key, list);
                }
            }
        }
        return list;
    }

    private ListenerMethod getListener(Object bean) {
        Method[] methods;
        if (bean == null) {
            return null;
        }
        for (Method method : methods = bean.getClass().getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(BusListener.class)) continue;
            return new ListenerMethod(bean, method);
        }
        return null;
    }

    private class ListenerMethod {
        private Object bean;
        private Method method;

        private ListenerMethod(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
        }

        public String toString() {
            return "ListenerMethod [bean=" + this.bean + ", method=" + this.method + "]";
        }
    }
}

