/*
 * Decompiled with CFR 0.152.
 */
package com.crossoverjie.distributed.lock;

import com.crossoverjie.distributed.util.ScriptUtil;
import java.util.Collections;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;

public class RedisLock {
    private static final String LOCK_MSG = "OK";
    private static final Long UNLOCK_MSG = 1L;
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    private String lockPrefix;
    private int sleepTime;
    private JedisCommands jedis;
    private static final int TIME = 1000;
    private String script;

    private RedisLock(Builder builder) {
        this.jedis = builder.jedis;
        this.lockPrefix = builder.lockPrefix;
        this.sleepTime = builder.sleepTime;
        this.buildScript();
    }

    public boolean tryLock(String key, String request) {
        String result = this.jedis.set(this.lockPrefix + key, request, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, 10000L);
        return LOCK_MSG.equals(result);
    }

    public void lock(String key, String request) throws InterruptedException {
        String result;
        while (!LOCK_MSG.equals(result = this.jedis.set(this.lockPrefix + key, request, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, 10000L))) {
            Thread.sleep(this.sleepTime);
        }
    }

    public boolean lock(String key, String request, int blockTime) throws InterruptedException {
        while (blockTime >= 0) {
            String result = this.jedis.set(this.lockPrefix + key, request, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, 10000L);
            if (LOCK_MSG.equals(result)) {
                return true;
            }
            blockTime -= this.sleepTime;
            Thread.sleep(this.sleepTime);
        }
        return false;
    }

    public boolean tryLock(String key, String request, int expireTime) {
        String result = this.jedis.set(this.lockPrefix + key, request, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, (long)expireTime);
        return LOCK_MSG.equals(result);
    }

    public boolean unlock(String key, String request) {
        Object result = null;
        if (this.jedis instanceof Jedis) {
            result = ((Jedis)this.jedis).eval(this.script, Collections.singletonList(this.lockPrefix + key), Collections.singletonList(request));
        } else if (this.jedis instanceof JedisCluster) {
            result = ((JedisCluster)this.jedis).eval(this.script, Collections.singletonList(this.lockPrefix + key), Collections.singletonList(request));
        } else {
            return false;
        }
        return UNLOCK_MSG.equals(result);
    }

    private void buildScript() {
        this.script = ScriptUtil.getScript("lock.lua");
    }

    public static class Builder<T extends JedisCommands> {
        private static final String DEFAULT_LOCK_PREFIX = "lock_";
        private static final int DEFAULT_SLEEP_TIME = 100;
        private T jedis;
        private String lockPrefix = "lock_";
        private int sleepTime = 100;

        public Builder(T jedis) {
            this.jedis = jedis;
        }

        public Builder lockPrefix(String lockPrefix) {
            this.lockPrefix = lockPrefix;
            return this;
        }

        public Builder sleepTime(int sleepTime) {
            this.sleepTime = sleepTime;
            return this;
        }

        public RedisLock build() {
            return new RedisLock(this);
        }
    }
}

