/*
 * Decompiled with CFR 0.152.
 */
package com.crossoverjie.distributed.limit;

import com.crossoverjie.distributed.util.ScriptUtil;
import java.util.Collections;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;

public class RedisLimit {
    private JedisCommands jedis;
    private int limit = 200;
    private static final int FAIL_CODE = 0;
    private String script;

    private RedisLimit(Builder builder) {
        this.limit = builder.limit;
        this.jedis = builder.jedis;
        this.buildScript();
    }

    public boolean limit() {
        String key = String.valueOf(System.currentTimeMillis() / 1000L);
        Object result = null;
        if (this.jedis instanceof Jedis) {
            result = ((Jedis)this.jedis).eval(this.script, Collections.singletonList(key), Collections.singletonList(String.valueOf(this.limit)));
        } else if (this.jedis instanceof JedisCluster) {
            result = ((JedisCluster)this.jedis).eval(this.script, Collections.singletonList(key), Collections.singletonList(String.valueOf(this.limit)));
        } else {
            return false;
        }
        return 0L != (Long)result;
    }

    private void buildScript() {
        this.script = ScriptUtil.getScript("limit.lua");
    }

    public static class Builder<T extends JedisCommands> {
        private T jedis = null;
        private int limit = 200;

        public Builder(T jedis) {
            this.jedis = jedis;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public RedisLimit build() {
            return new RedisLimit(this);
        }
    }
}

