/*
 * Decompiled with CFR 0.152.
 */
package com.crossoverjie.distributed.intercept;

import com.crossoverjie.distributed.annotation.ControllerLimit;
import com.crossoverjie.distributed.limit.RedisLimit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class WebIntercept
extends WebMvcConfigurerAdapter {
    private static Logger logger = LoggerFactory.getLogger(WebIntercept.class);
    @Autowired
    private RedisLimit redisLimit;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new CustomInterceptor()).addPathPatterns(new String[]{"/**"});
    }

    private class CustomInterceptor
    extends HandlerInterceptorAdapter {
        private CustomInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            if (WebIntercept.this.redisLimit == null) {
                throw new NullPointerException("redisLimit is null");
            }
            if (handler instanceof HandlerMethod) {
                HandlerMethod method = (HandlerMethod)handler;
                ControllerLimit annotation = (ControllerLimit)method.getMethodAnnotation(ControllerLimit.class);
                if (annotation == null) {
                    return true;
                }
                boolean limit = WebIntercept.this.redisLimit.limit();
                if (!limit) {
                    logger.warn("request has bean limit");
                    response.sendError(500, "request limit");
                    return false;
                }
            }
            return true;
        }
    }
}

