/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.provider.base;

import java.util.ArrayList;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;

public class BaseSelectProvider
extends MapperTemplate {
    public BaseSelectProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public SqlNode selectOne(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        ArrayList<Object> sqlNodes = new ArrayList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT " + EntityHelper.getSelectColumns(entityClass) + " FROM "));
        sqlNodes.add(this.getDynamicTableNameNode(entityClass));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode select(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        ArrayList<Object> sqlNodes = new ArrayList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT " + EntityHelper.getSelectColumns(entityClass) + " FROM "));
        sqlNodes.add(this.getDynamicTableNameNode(entityClass));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sqlNodes.add(new StaticTextSqlNode("ORDER BY " + orderByClause));
        }
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectByRowBounds(MappedStatement ms) {
        return this.select(ms);
    }

    public String selectByPrimaryKey(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(EntityHelper.getSelectColumns(entityClass));
        sql.append(" from ");
        sql.append(this.getDynamicTableName(entityClass));
        sql.append(" where ");
        sql.append(EntityHelper.getPrimaryKeyWhere(entityClass));
        return sql.toString();
    }

    public SqlNode selectCount(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        ArrayList<Object> sqlNodes = new ArrayList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT COUNT(*) FROM "));
        sqlNodes.add(this.getDynamicTableNameNode(entityClass));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public String selectAll(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(EntityHelper.getSelectColumns(entityClass)).append(" from ");
        sql.append(this.tableName(entityClass));
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append(" ORDER BY ").append(orderByClause);
        }
        return sql.toString();
    }
}

