/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.provider;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SetSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;

public class MapperProvider
extends MapperTemplate {
    public MapperProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public SqlNode selectOne(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        this.setResultType(ms, entityClass);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT " + EntityHelper.getSelectColumns(entityClass) + " FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode select(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        this.setResultType(ms, entityClass);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT " + EntityHelper.getSelectColumns(entityClass) + " FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sqlNodes.add(new StaticTextSqlNode("ORDER BY " + orderByClause));
        }
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectByRowBounds(MappedStatement ms) {
        return this.select(ms);
    }

    public void selectByPrimaryKey(MappedStatement ms) {
        final Class<?> entityClass = this.getSelectReturnType(ms);
        List<ParameterMapping> parameterMappings = this.getPrimaryKeyParameterMappings(ms);
        String sql = new SQL(){
            {
                this.SELECT(EntityHelper.getSelectColumns(entityClass));
                this.FROM(MapperProvider.this.tableName(entityClass));
                this.WHERE(EntityHelper.getPrimaryKeyWhere(entityClass));
            }
        }.toString();
        StaticSqlSource sqlSource = new StaticSqlSource(ms.getConfiguration(), sql, parameterMappings);
        this.setSqlSource(ms, (SqlSource)sqlSource);
        this.setResultType(ms, entityClass);
    }

    public SqlNode selectCount(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT COUNT(*) FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode insert(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("INSERT INTO " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        Boolean hasIdentityKey = false;
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.getSequenceName() != null && column.getSequenceName().length() > 0) continue;
            if (column.isIdentity()) {
                sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_cache", column.getProperty()));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new RuntimeException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                this.newSelectKeyMappedStatement(ms, column);
                hasIdentityKey = true;
                continue;
            }
            if (!column.isUuid()) continue;
            sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_bind", this.getUUID()));
        }
        sqlNodes.add(new StaticTextSqlNode("(" + EntityHelper.getAllColumns(entityClass) + ")"));
        LinkedList<SqlNode> ifNodes = new LinkedList<SqlNode>();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isIdentity()) {
                ifNodes.add(this.getIfCacheNotNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_cache },")));
            } else {
                ifNodes.add(this.getIfNotNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "},")));
            }
            if (column.getSequenceName() != null && column.getSequenceName().length() > 0) {
                ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode(this.getSeqNextVal(column) + " ,")));
                continue;
            }
            if (column.isIdentity()) {
                ifNodes.add(this.getIfCacheIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + " },")));
                continue;
            }
            if (column.isUuid()) {
                ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_bind },")));
                continue;
            }
            ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + ",jdbcType=VARCHAR},")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "VALUES (", null, ")", ","));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode insertSelective(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("INSERT INTO " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        LinkedList<Object> ifNodes = new LinkedList<Object>();
        Boolean hasIdentityKey = false;
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.getSequenceName() != null && column.getSequenceName().length() > 0) {
                ifNodes.add(new StaticTextSqlNode(column.getColumn() + ","));
                continue;
            }
            if (column.isIdentity()) {
                sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_cache", column.getProperty()));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new RuntimeException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                this.newSelectKeyMappedStatement(ms, column);
                hasIdentityKey = true;
                ifNodes.add(new StaticTextSqlNode(column.getColumn() + ","));
                continue;
            }
            if (column.isUuid()) {
                sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_bind", this.getUUID()));
                ifNodes.add(new StaticTextSqlNode(column.getColumn() + ","));
                continue;
            }
            ifNodes.add(this.getIfNotNull(column, (SqlNode)new StaticTextSqlNode(column.getColumn() + ",")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "(", null, ")", ","));
        ifNodes = new LinkedList();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isIdentity()) {
                ifNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_cache },"), column.getProperty() + "_cache != null "));
            } else {
                ifNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "},"), column.getProperty() + " != null "));
            }
            if (column.getSequenceName() != null && column.getSequenceName().length() > 0) {
                ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode(this.getSeqNextVal(column) + " ,")));
                continue;
            }
            if (column.isIdentity()) {
                ifNodes.add(this.getIfCacheIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + " },")));
                continue;
            }
            if (!column.isUuid()) continue;
            ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_bind },")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "VALUES (", null, ")", ","));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode delete(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("DELETE FROM " + this.tableName(entityClass)));
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), this.getAllIfColumnNode(entityClass)));
        return new MixedSqlNode(sqlNodes);
    }

    public void deleteByPrimaryKey(MappedStatement ms) {
        final Class<?> entityClass = this.getSelectReturnType(ms);
        List<ParameterMapping> parameterMappings = this.getPrimaryKeyParameterMappings(ms);
        String sql = new SQL(){
            {
                this.DELETE_FROM(MapperProvider.this.tableName(entityClass));
                this.WHERE(EntityHelper.getPrimaryKeyWhere(entityClass));
            }
        }.toString();
        StaticSqlSource sqlSource = new StaticSqlSource(ms.getConfiguration(), sql, parameterMappings);
        this.setSqlSource(ms, (SqlSource)sqlSource);
    }

    public SqlNode updateByPrimaryKey(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("UPDATE " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        LinkedList<StaticTextSqlNode> ifNodes = new LinkedList<StaticTextSqlNode>();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isId()) continue;
            ifNodes.add(new StaticTextSqlNode(column.getColumn() + " = #{" + column.getProperty() + "}, "));
        }
        sqlNodes.add(new SetSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes)));
        columnList = EntityHelper.getPKColumns(entityClass);
        LinkedList<SqlNode> whereNodes = new LinkedList<SqlNode>();
        boolean first = true;
        for (EntityHelper.EntityColumn column : columnList) {
            whereNodes.add(this.getColumnEqualsProperty(column, first));
            first = false;
        }
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(whereNodes)));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode updateByPrimaryKeySelective(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("UPDATE " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        LinkedList<SqlNode> ifNodes = new LinkedList<SqlNode>();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isId()) continue;
            StaticTextSqlNode columnNode = new StaticTextSqlNode(column.getColumn() + " = #{" + column.getProperty() + "}, ");
            ifNodes.add(this.getIfNotNull(column, (SqlNode)columnNode));
        }
        sqlNodes.add(new SetSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes)));
        columnList = EntityHelper.getPKColumns(entityClass);
        LinkedList<SqlNode> whereNodes = new LinkedList<SqlNode>();
        boolean first = true;
        for (EntityHelper.EntityColumn column : columnList) {
            whereNodes.add(this.getColumnEqualsProperty(column, first));
            first = false;
        }
        sqlNodes.add(new WhereSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(whereNodes)));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectCountByExample(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT COUNT(*) FROM " + this.tableName(entityClass)));
        IfSqlNode ifNullSqlNode = new IfSqlNode((SqlNode)this.exampleWhereClause(ms.getConfiguration()), "_parameter != null");
        sqlNodes.add(ifNullSqlNode);
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode deleteByExample(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("DELETE FROM " + this.tableName(entityClass)));
        IfSqlNode ifNullSqlNode = new IfSqlNode((SqlNode)this.exampleWhereClause(ms.getConfiguration()), "_parameter != null");
        sqlNodes.add(ifNullSqlNode);
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectByExample(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        this.setResultType(ms, entityClass);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("SELECT"));
        IfSqlNode distinctSqlNode = new IfSqlNode((SqlNode)new StaticTextSqlNode("DISTINCT"), "distinct");
        sqlNodes.add(distinctSqlNode);
        sqlNodes.add(new StaticTextSqlNode(EntityHelper.getSelectColumns(entityClass) + " FROM " + this.tableName(entityClass)));
        IfSqlNode ifNullSqlNode = new IfSqlNode((SqlNode)this.exampleWhereClause(ms.getConfiguration()), "_parameter != null");
        sqlNodes.add(ifNullSqlNode);
        IfSqlNode orderByClauseSqlNode = new IfSqlNode((SqlNode)new TextSqlNode("order by ${orderByClause}"), "orderByClause != null");
        sqlNodes.add(orderByClauseSqlNode);
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            IfSqlNode defaultOrderByClauseSqlNode = new IfSqlNode((SqlNode)new StaticTextSqlNode("ORDER BY " + orderByClause), "orderByClause == null");
            sqlNodes.add(defaultOrderByClauseSqlNode);
        }
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectByExampleAndRowBounds(MappedStatement ms) {
        return this.selectByExample(ms);
    }

    public SqlNode updateByExampleSelective(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("UPDATE " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        LinkedList<IfSqlNode> ifNodes = new LinkedList<IfSqlNode>();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isId()) continue;
            StaticTextSqlNode columnNode = new StaticTextSqlNode(column.getColumn() + " = #{record." + column.getProperty() + "}, ");
            ifNodes.add(new IfSqlNode((SqlNode)columnNode, "record." + column.getProperty() + " != null"));
        }
        sqlNodes.add(new SetSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes)));
        IfSqlNode ifNullSqlNode = new IfSqlNode((SqlNode)this.updateByExampleWhereClause(ms.getConfiguration()), "_parameter != null");
        sqlNodes.add(ifNullSqlNode);
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode updateByExample(MappedStatement ms) {
        Class<?> entityClass = this.getSelectReturnType(ms);
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(new StaticTextSqlNode("UPDATE " + this.tableName(entityClass)));
        Set<EntityHelper.EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        LinkedList<StaticTextSqlNode> setSqlNodes = new LinkedList<StaticTextSqlNode>();
        for (EntityHelper.EntityColumn column : columnList) {
            if (column.isId()) continue;
            setSqlNodes.add(new StaticTextSqlNode(column.getColumn() + " = #{record." + column.getProperty() + "}, "));
        }
        sqlNodes.add(new SetSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(setSqlNodes)));
        IfSqlNode ifNullSqlNode = new IfSqlNode((SqlNode)this.updateByExampleWhereClause(ms.getConfiguration()), "_parameter != null");
        sqlNodes.add(ifNullSqlNode);
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode selectCountByCondition(MappedStatement ms) {
        return this.selectCountByExample(ms);
    }

    public SqlNode deleteByCondition(MappedStatement ms) {
        return this.deleteByExample(ms);
    }

    public SqlNode selectByCondition(MappedStatement ms) {
        return this.selectByCondition(ms);
    }

    public SqlNode selectByConditionAndRowBounds(MappedStatement ms) {
        return this.selectByExample(ms);
    }

    public SqlNode updateByConditionSelective(MappedStatement ms) {
        return this.updateByExampleSelective(ms);
    }

    public SqlNode updateByCondition(MappedStatement ms) {
        return this.updateByCondition(ms);
    }
}

