/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.examples.taglib;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.standard.examples.util.IOBean;
import org.apache.taglibs.standard.examples.util.ServletResponseWrapperForWriter;

public class ResourceTag
extends TagSupport {
    private String id;
    private String resource;
    private Reader reader;

    public ResourceTag() {
        this.init();
    }

    private void init() {
        this.id = null;
        this.resource = null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public int doStartTag() throws JspException {
        this.reader = this.getReaderFromResource(this.resource);
        this.exposeVariable(this.reader);
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
        return 6;
    }

    public void release() {
        super.release();
        this.init();
    }

    private Reader getReaderFromResource(String name) throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        RequestDispatcher rd = null;
        IOBean ioBean = new IOBean();
        Writer writer = ioBean.getWriter();
        ServletResponseWrapperForWriter responseWrapper = new ServletResponseWrapperForWriter((ServletResponse)response, new PrintWriter(writer));
        rd = this.pageContext.getServletContext().getRequestDispatcher(name);
        try {
            rd.include((ServletRequest)request, (ServletResponse)responseWrapper);
            return ioBean.getReader();
        }
        catch (Exception ex) {
            throw new JspException((Throwable)ex);
        }
    }

    private void exposeVariable(Reader reader) {
        if (this.id != null) {
            this.pageContext.setAttribute(this.id, (Object)reader);
        }
    }
}

