/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.examples.taglib;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.examples.util.Util;

public class EscapeHtmlTag
extends BodyTagSupport {
    private Object reader;
    private Object writer;

    public EscapeHtmlTag() {
        this.init();
    }

    private void init() {
        this.reader = null;
        this.writer = null;
    }

    public void setReader(Object reader) {
        this.reader = reader;
    }

    public void setWriter(Object writer) {
        this.writer = writer;
    }

    public int doEndTag() throws JspException {
        Reader in;
        if (this.reader == null) {
            String bcs = this.getBodyContent().getString().trim();
            if (bcs == null || bcs.equals("")) {
                throw new JspTagException("In &lt;escapeHtml&gt;, 'reader' not specified and no non-whitespace content inside the tag.");
            }
            in = Util.castToReader((Object)bcs);
        } else {
            in = Util.castToReader((Object)this.reader);
        }
        Object out = this.writer == null ? this.pageContext.getOut() : Util.castToWriter((Object)this.writer);
        this.transform(in, (Writer)out);
        return 6;
    }

    public void release() {
        super.release();
        this.init();
    }

    public void transform(Reader reader, Writer writer) throws JspException {
        try {
            int c;
            writer.write("<pre>");
            while ((c = reader.read()) != -1) {
                if (c == 60) {
                    writer.write("&lt;");
                    continue;
                }
                if (c == 62) {
                    writer.write("&gt;");
                    continue;
                }
                writer.write(c);
            }
            writer.write("</pre>");
        }
        catch (IOException ex) {
            throw new JspException("EscapeHtml: error copying chars", (Throwable)ex);
        }
    }
}

