/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.random;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.random.RandomStrg;

public class RandomStrgTag
extends TagSupport {
    private boolean allchars = false;
    private Integer length = new Integer(8);
    private HashMap hmap;
    private String map = null;
    private ArrayList lower = null;
    private ArrayList upper = null;
    private char[] single = null;
    private int singlecount = 0;
    private String algorithm = null;
    private String provider = null;
    private String charset = null;

    public final int doStartTag() throws JspException {
        RandomStrg random = new RandomStrg();
        if (this.charset != null) {
            this.generateCharset(this.charset);
        } else {
            this.generateCharset("a-zA-Z0-9");
        }
        if (this.map != null) {
            try {
                this.hmap = (HashMap)this.pageContext.findAttribute(this.map);
                if (this.hmap == null) {
                    throw new JspException("A hashmap does not exist in any scope under the name " + this.map);
                }
            }
            catch (ClassCastException cce) {
                throw new JspException("The named attribute exists but it is not a hashmap.");
            }
            random.setHmap(this.hmap);
        }
        if (this.lower != null) {
            random.setRanges(this.lower, this.upper);
        }
        if (this.single != null) {
            random.setSingle(this.single, this.singlecount);
        }
        random.setLength(this.length);
        random.setAllchars(this.allchars);
        if (this.algorithm != null) {
            random.setAlgorithm(this.algorithm);
        }
        if (this.provider != null) {
            random.setProvider(this.provider);
        }
        random.generateRandomObject();
        this.pageContext.setAttribute(this.id, (Object)random, 1);
        return 0;
    }

    public final void setMap(String value) {
        this.map = value;
    }

    public final void setLength(String value) {
        try {
            this.length = new Integer(value);
        }
        catch (NumberFormatException ne) {
            this.pageContext.getServletContext().log("length attribute could not be turned into an Integer default value was used");
        }
    }

    public final void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public final void setProvider(String value) {
        this.provider = value;
    }

    public final void setCharset(String value) {
        this.charset = value;
    }

    private void generateCharset(String value) {
        boolean more = true;
        this.allchars = false;
        this.single = null;
        this.singlecount = 0;
        this.lower = new ArrayList(3);
        this.upper = new ArrayList(3);
        if (value.compareTo("all") == 0) {
            this.allchars = true;
            more = false;
        } else if (value.charAt(1) == '-' && value.charAt(0) != '\\') {
            while (more && value.charAt(1) == '-' && value.charAt(0) != '\\') {
                this.lower.add(new Character(value.charAt(0)));
                this.upper.add(new Character(value.charAt(2)));
                if (value.length() <= 3) {
                    more = false;
                    continue;
                }
                value = value.substring(3);
            }
        }
        if (more) {
            this.single = new char[30];
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.length() > 1) {
                    this.single[this.singlecount++] = 45;
                }
                this.single[this.singlecount++] = token.charAt(0);
            }
        }
    }
}

