/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.log;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public abstract class LoggerTag
extends BodyTagSupport {
    private String category;
    private String message;

    public void setCategory(String category) {
        this.category = category;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int doStartTag() throws JspException {
        if (this.message != null) {
            Priority priority;
            Category logCategory = this.getLoggingCategory();
            if (logCategory.isEnabledFor(priority = this.getPriority())) {
                logCategory.log(priority, (Object)this.message);
            }
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        Priority priority;
        Category logCategory;
        if (this.message == null && (logCategory = this.getLoggingCategory()).isEnabledFor(priority = this.getPriority())) {
            logCategory.log(priority, (Object)this.getBodyContent().getString().trim());
        }
        return 0;
    }

    protected abstract Priority getPriority();

    protected Category getLoggingCategory() {
        if (this.category == null) {
            return Category.getRoot();
        }
        return Category.getInstance((String)this.category);
    }
}

