/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.hmac;

import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.hmac.HmacMd5;
import com.sshtools.j2ssh.transport.hmac.HmacMd596;
import com.sshtools.j2ssh.transport.hmac.HmacSha;
import com.sshtools.j2ssh.transport.hmac.HmacSha96;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshHmacFactory {
    private static String defaultAlgorithm;
    private static Map macs;
    private static Log log;

    protected SshHmacFactory() {
    }

    public static void initialize() {
    }

    public static final String getDefaultHmac() {
        return defaultAlgorithm;
    }

    public static List getSupportedMacs() {
        return new ArrayList(macs.keySet());
    }

    public static SshHmac newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshHmac)((Class)macs.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog((Class)SshHmacFactory.class);
        macs = new HashMap();
        log.info((Object)"Loading message authentication methods");
        macs.put("hmac-sha1", HmacSha.class);
        macs.put("hmac-sha1-96", HmacSha96.class);
        macs.put("hmac-md5", HmacMd5.class);
        macs.put("hmac-md5-96", HmacMd596.class);
        defaultAlgorithm = "hmac-sha1";
    }
}

