/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubsystemClient
implements Runnable {
    private static Log log = LogFactory.getLog((Class)SubsystemClient.class);
    private InputStream in;
    private OutputStream out;
    private Thread thread;
    private String name;
    private StartStopState state = new StartStopState(2);
    protected SubsystemMessageStore messageStore;
    protected SessionChannelClient session;

    public SubsystemClient(String string) {
        this.name = string;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemClient(String string, SubsystemMessageStore subsystemMessageStore) {
        this.name = string;
        this.messageStore = subsystemMessageStore;
    }

    public boolean isClosed() {
        return this.state.getValue() == 2;
    }

    public void setSessionChannel(SessionChannelClient sessionChannelClient) {
        this.session = sessionChannelClient;
        this.in = sessionChannelClient.getInputStream();
        this.out = sessionChannelClient.getOutputStream();
        sessionChannelClient.setName(this.name);
    }

    public SessionChannelClient getSessionChannel() {
        return this.session;
    }

    public boolean start() throws IOException {
        this.thread = new SshThread(this, this.name + " subsystem", true);
        if (this.session == null) {
            throw new IOException("No valid session is attached to the subsystem!");
        }
        if (this.session.getState().getValue() != 2) {
            throw new IOException("The session is not open!");
        }
        this.thread.start();
        return this.onStart();
    }

    protected abstract boolean onStart() throws IOException;

    public String getName() {
        return this.name;
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) throws InvalidMessageException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + subsystemMessage.getMessageName() + " subsystem message"));
        }
        byte[] byArray = subsystemMessage.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(byArray.length));
        this.out.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = new byte[4];
        this.state.setValue(1);
        try {
            while (this.state.getValue() == 1 && this.session.getState().getValue() == 2) {
                int n = this.in.read(byArray);
                if (n > 0) {
                    int n2 = (int)ByteArrayReader.readInt(byArray, 0);
                    byte[] byArray2 = new byte[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        n = this.in.read(byArray2, n3, byArray2.length - n3);
                        if (n > 0) {
                            n3 += n;
                            continue;
                        }
                        if (n != -1) continue;
                    }
                    this.messageStore.addMessage(byArray2);
                    byArray2 = null;
                    continue;
                }
                if (n != -1) continue;
                break;
            }
        }
        catch (IOException iOException) {
            log.fatal((Object)"Subsystem message loop failed!", (Throwable)iOException);
        }
        finally {
            this.state.setValue(2);
        }
        this.thread = null;
    }

    public void stop() throws IOException {
        this.state.setValue(2);
        this.in.close();
        this.out.close();
        this.session.close();
    }
}

