/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgGlobalRequest
extends SshMessage {
    protected static final int SSH_MSG_GLOBAL_REQUEST = 80;
    private String requestName;
    private byte[] requestData;
    private boolean wantReply;

    public SshMsgGlobalRequest(String string, boolean bl, byte[] byArray) {
        super(80);
        this.requestName = string;
        this.wantReply = bl;
        this.requestData = byArray;
    }

    public SshMsgGlobalRequest() {
        super(80);
    }

    public String getMessageName() {
        return "SSH_MSG_GLOBAL_REQUEST";
    }

    public byte[] getRequestData() {
        return this.requestData;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public boolean getWantReply() {
        return this.wantReply;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeString(this.requestName);
            byteArrayWriter.write(this.wantReply ? 1 : 0);
            if (this.requestData != null) {
                byteArrayWriter.write(this.requestData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.requestName = byteArrayReader.readString();
            boolean bl = this.wantReply = byteArrayReader.read() != 0;
            if (byteArrayReader.available() > 0) {
                this.requestData = new byte[byteArrayReader.available()];
                byteArrayReader.read(this.requestData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

