/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.rest;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import solutions.siren.join.action.coordinate.CoordinateMultiSearchAction;

public class RestCoordinateMultiSearchAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    @Inject
    public RestCoordinateMultiSearchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_coordinate_msearch", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_coordinate_msearch", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_coordinate_msearch", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_coordinate_msearch", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_coordinate_msearch", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_coordinate_msearch", (RestHandler)this);
        this.allowExplicitIndex = settings.getAsBoolean("rest.action.multi.allow_explicit_index", Boolean.valueOf(true));
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        String[] types = Strings.splitStringByCommaToArray((String)request.param("type"));
        String path = request.path();
        boolean isTemplateRequest = this.isTemplateRequest(path);
        IndicesOptions indicesOptions = IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)multiSearchRequest.indicesOptions());
        multiSearchRequest.add(RestActions.getRestContent((RestRequest)request), isTemplateRequest, indices, types, request.param("search_type"), request.param("routing"), indicesOptions, this.allowExplicitIndex);
        client.execute((Action)CoordinateMultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private boolean isTemplateRequest(String path) {
        return path != null && path.endsWith("/template");
    }
}

