/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.index.query;

import java.io.IOException;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import solutions.siren.join.index.query.TermsEnumTermsQuery;

public class TermsEnumTermsQueryParser
implements QueryParser {
    public static final String NAME = "termsenum_terms";
    private static final ESLogger logger = Loggers.getLogger(TermsEnumTermsQueryParser.class);

    public String[] names() {
        return new String[]{NAME};
    }

    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext, "[termsenum_terms] a field name is required", new Object[0]);
        }
        String fieldName = parser.currentName();
        String queryName = null;
        byte[] value = null;
        Long cacheKey = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.binaryValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = parser.longValue();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[termsenum_terms] filter does not support [" + currentFieldName + "]", new Object[0]);
            }
            parser.nextToken();
        } else {
            value = parser.binaryValue();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "[termsenum_terms] a binary value is required", new Object[0]);
        }
        if (cacheKey == null) {
            throw new QueryParsingException(parseContext, "[termsenum_terms] a cache key is required", new Object[0]);
        }
        if (fieldName == null) {
            throw new QueryParsingException(parseContext, "[termsenum_terms] a field name is required", new Object[0]);
        }
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType == null) {
            return new MatchNoDocsQuery();
        }
        TermsEnumTermsQuery query = new TermsEnumTermsQuery(value, fieldName, cacheKey);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)query);
        }
        return query;
    }
}

