/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.terms.collector.BytesRefTermsSet;
import solutions.siren.join.action.terms.collector.TermsSet;

public class TermsEnumTermsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermsEnumTermsQuery.class);
    private byte[] encodedTerms;
    private BytesRefTermsSet termsSet;
    protected String field;
    protected final long cacheKey;
    private static final ESLogger logger = Loggers.getLogger(TermsEnumTermsQuery.class);

    public TermsEnumTermsQuery(byte[] encodedTerms, String field, long cacheKey) {
        this.encodedTerms = encodedTerms;
        this.cacheKey = cacheKey;
        this.field = field;
    }

    public long ramBytesUsed() {
        BytesRefTermsSet termsSet = this.getTermsSet();
        return BASE_RAM_BYTES_USED + (long)(termsSet.size() * 8);
    }

    public String toString(String defaultField) {
        BytesRefTermsSet termsSet = this.getTermsSet();
        StringBuilder sb = new StringBuilder("TermsEnumTermsQuery:");
        return sb.append(defaultField).append(":").append("[size=" + termsSet.size() + "]").toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.cacheKey != ((TermsEnumTermsQuery)((Object)obj)).cacheKey) {
            return false;
        }
        return this.field.equals(((TermsEnumTermsQuery)((Object)obj)).field);
    }

    public int hashCode() {
        int hashcode = super.hashCode();
        hashcode = 31 * hashcode + (int)this.cacheKey;
        hashcode = 31 * hashcode + this.field.hashCode();
        return hashcode;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    protected synchronized BytesRefTermsSet getTermsSet() {
        if (this.encodedTerms != null) {
            long start = System.nanoTime();
            this.termsSet = (BytesRefTermsSet)TermsSet.readFrom(new BytesRef(this.encodedTerms));
            logger.debug("{}: Deserialized {} terms - took {} ms", new Object[]{Thread.currentThread().getName(), this.termsSet.size(), (System.nanoTime() - start) / 1000000L});
            this.encodedTerms = null;
        }
        return this.termsSet;
    }

    public DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
        Terms terms = context.reader().terms(this.field);
        if (terms == null) {
            return null;
        }
        BytesRefTermsSet termsSet = this.getTermsSet();
        if (termsSet == null || termsSet.isEmpty()) {
            return null;
        }
        SeekingTermSetTermsEnum termsEnum = new SeekingTermSetTermsEnum(terms.iterator(), termsSet);
        DocIdSetBuilder builder = new DocIdSetBuilder(context.reader().maxDoc());
        PostingsEnum docs = null;
        while (termsEnum.next() != null) {
            docs = termsEnum.postings(docs, 0);
            builder.add((DocIdSetIterator)docs);
        }
        return builder.build();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight((Query)new CacheKeyFieldDataTermsQuery(this.cacheKey)){

            public void extractTerms(Set<Term> terms) {
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                Scorer scorer = this.scorer(TermsEnumTermsQuery.this.getDocIdSet(context));
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                return this.scorer(TermsEnumTermsQuery.this.getDocIdSet(context));
            }
        };
    }

    static class SeekingTermSetTermsEnum
    extends FilteredTermsEnum {
        private final BytesRefHash terms;
        private final int[] ords;
        private final int lastElement;
        private final BytesRef lastTerm;
        private final BytesRef spare = new BytesRef();
        private BytesRef seekTerm;
        private int upto = 0;

        SeekingTermSetTermsEnum(TermsEnum tenum, BytesRefTermsSet termsSet) {
            super(tenum);
            this.terms = termsSet.getBytesRefHash();
            this.ords = this.terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
            this.lastElement = this.terms.size() - 1;
            this.lastTerm = this.terms.get(this.ords[this.lastElement], new BytesRef());
            this.seekTerm = this.terms.get(this.ords[this.upto], this.spare);
        }

        protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
            BytesRef temp = this.seekTerm;
            this.seekTerm = null;
            return temp;
        }

        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            int cmp;
            if (term.compareTo(this.lastTerm) > 0) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            BytesRef currentTerm = this.terms.get(this.ords[this.upto], this.spare);
            if (term.compareTo(currentTerm) == 0) {
                if (this.upto == this.lastElement) {
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            if (this.upto == this.lastElement) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            do {
                if (this.upto == this.lastElement) {
                    return FilteredTermsEnum.AcceptStatus.NO;
                }
                this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
            } while ((cmp = this.seekTerm.compareTo(term)) < 0);
            if (cmp == 0) {
                if (this.upto == this.lastElement) {
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
        }
    }

    private static class CacheKeyFieldDataTermsQuery
    extends MultiTermQuery {
        private final long cacheKey;

        public CacheKeyFieldDataTermsQuery(long cacheKey) {
            super("");
            this.cacheKey = cacheKey;
        }

        public String toString(String field) {
            StringBuilder sb = new StringBuilder("CacheKeyFieldDataTermsQuery:");
            return sb.append(field).append(":").append("[cacheKey=" + this.cacheKey + "]").toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKeyFieldDataTermsQuery)) {
                return false;
            }
            CacheKeyFieldDataTermsQuery other = (CacheKeyFieldDataTermsQuery)((Object)o);
            return super.equals(o) && this.cacheKey == other.cacheKey;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)this.cacheKey;
            return result;
        }
    }
}

