/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import solutions.siren.join.action.terms.TermsByQueryRequest;

public class FilterJoinBuilder
extends QueryBuilder
implements BoostableQueryBuilder<FilterJoinBuilder> {
    private final String name;
    private String[] indices;
    private String[] types;
    private String routing;
    private String path;
    private QueryBuilder query;
    private TermsByQueryRequest.Ordering orderBy;
    private Integer maxTermsPerShard;
    private String filterName;
    private TermsByQueryRequest.TermsEncoding termsEncoding;
    private float boost = -1.0f;
    public static final String NAME = "filterjoin";

    public FilterJoinBuilder(String name) {
        this.name = name;
    }

    public FilterJoinBuilder indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public FilterJoinBuilder types(String ... types) {
        this.types = types;
        return this;
    }

    public FilterJoinBuilder path(String path) {
        this.path = path;
        return this;
    }

    public FilterJoinBuilder routing(String lookupRouting) {
        this.routing = lookupRouting;
        return this;
    }

    public FilterJoinBuilder query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    public FilterJoinBuilder orderBy(TermsByQueryRequest.Ordering orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public FilterJoinBuilder maxTermsPerShard(int maxTermsPerShard) {
        this.maxTermsPerShard = maxTermsPerShard;
        return this;
    }

    public FilterJoinBuilder termsEncoding(TermsByQueryRequest.TermsEncoding termsEncoding) {
        this.termsEncoding = termsEncoding;
        return this;
    }

    public FilterJoinBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.name);
        if (this.indices != null) {
            builder.field("indices", this.indices);
        }
        if (this.types != null) {
            builder.field("types", this.types);
        }
        if (this.routing != null) {
            builder.field("routing", this.routing);
        }
        builder.field("path", this.path);
        builder.field("query", (ToXContent)this.query);
        if (this.orderBy != null) {
            builder.field("orderBy", (Object)this.orderBy);
        }
        if (this.maxTermsPerShard != null) {
            builder.field("maxTermsPerShard", this.maxTermsPerShard);
        }
        if (this.termsEncoding != null) {
            builder.field("termsEncoding", (Object)this.termsEncoding);
        }
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }

    public FilterJoinBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }
}

