/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.index.query;

import java.io.IOException;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import solutions.siren.join.index.query.FieldDataTermsQuery;

public class FieldDataTermsQueryParser
implements QueryParser {
    public static final String NAME = "fielddata_terms";
    private static final ESLogger logger = Loggers.getLogger(FieldDataTermsQueryParser.class);

    public String[] names() {
        return new String[]{NAME};
    }

    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext, "[fielddata_terms] a field name is required", new Object[0]);
        }
        String fieldName = parser.currentName();
        String queryName = null;
        byte[] value = null;
        Long cacheKey = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.binaryValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = parser.longValue();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[fielddata_terms] filter does not support [" + currentFieldName + "]", new Object[0]);
            }
            parser.nextToken();
        } else {
            value = parser.binaryValue();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "[fielddata_terms] a binary value is required", new Object[0]);
        }
        if (cacheKey == null) {
            throw new QueryParsingException(parseContext, "[fielddata_terms] a cache key is required", new Object[0]);
        }
        if (fieldName == null) {
            throw new QueryParsingException(parseContext, "[fielddata_terms] a field name is required", new Object[0]);
        }
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType == null) {
            return new MatchNoDocsQuery();
        }
        IndexFieldData fieldData = parseContext.getForField(fieldType);
        Query query = this.toFieldDataTermsQuery(fieldType, fieldData, value, cacheKey);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    private final Query toFieldDataTermsQuery(MappedFieldType fieldType, IndexFieldData fieldData, byte[] encodedTerms, long cacheKey) {
        FieldDataTermsQuery query = null;
        if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
            query = FieldDataTermsQuery.newLongs(encodedTerms, (IndexNumericFieldData)fieldData, cacheKey);
        } else if (fieldType instanceof StringFieldMapper.StringFieldType) {
            query = FieldDataTermsQuery.newBytes(encodedTerms, fieldData, cacheKey);
        } else {
            throw new ElasticsearchParseException("[fielddata_terms] query does not support field data type " + fieldType.fieldDataType().getType(), new Object[0]);
        }
        return query;
    }
}

