/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesDocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import solutions.siren.join.action.terms.collector.LongBloomFilter;
import solutions.siren.join.action.terms.collector.NumericTermsSet;
import solutions.siren.join.action.terms.collector.TermsSet;

public abstract class FieldDataTermsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldDataTermsQuery.class);
    private byte[] encodedTerms;
    private NumericTermsSet termsSet;
    protected final IndexFieldData fieldData;
    protected final long cacheKey;
    private static final ESLogger logger = Loggers.getLogger(FieldDataTermsQuery.class);

    public static FieldDataTermsQuery newLongs(byte[] encodedTerms, IndexNumericFieldData fieldData, long cacheKey) {
        return new LongsFieldDataTermsQuery(encodedTerms, (IndexFieldData)fieldData, cacheKey);
    }

    public static FieldDataTermsQuery newBytes(byte[] encodedTerms, IndexFieldData fieldData, long cacheKey) {
        return new BytesFieldDataTermsQuery(encodedTerms, fieldData, cacheKey);
    }

    public FieldDataTermsQuery(byte[] encodedTerms, IndexFieldData fieldData, long cacheKey) {
        this.encodedTerms = encodedTerms;
        this.fieldData = fieldData;
        this.cacheKey = cacheKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.cacheKey == ((FieldDataTermsQuery)((Object)obj)).cacheKey;
    }

    public int hashCode() {
        int hashcode = super.hashCode();
        hashcode = 31 * hashcode + (int)this.cacheKey;
        return hashcode;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    protected synchronized NumericTermsSet getTermsSet() {
        if (this.encodedTerms != null) {
            long start = System.nanoTime();
            this.termsSet = (NumericTermsSet)TermsSet.readFrom(new BytesRef(this.encodedTerms));
            logger.debug("{}: Deserialized {} terms - took {} ms", new Object[]{Thread.currentThread().getName(), this.termsSet.size(), (System.nanoTime() - start) / 1000000L});
            this.encodedTerms = null;
        }
        return this.termsSet;
    }

    public abstract DocIdSet getDocIdSet(LeafReaderContext var1) throws IOException;

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight((Query)new CacheKeyFieldDataTermsQuery(this.cacheKey)){

            public void extractTerms(Set<Term> terms) {
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                Scorer scorer = this.scorer(FieldDataTermsQuery.this.getDocIdSet(context));
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                return this.scorer(FieldDataTermsQuery.this.getDocIdSet(context));
            }
        };
    }

    private static class CacheKeyFieldDataTermsQuery
    extends MultiTermQuery {
        private final long cacheKey;

        public CacheKeyFieldDataTermsQuery(long cacheKey) {
            super("");
            this.cacheKey = cacheKey;
        }

        public String toString(String field) {
            StringBuilder sb = new StringBuilder("CacheKeyFieldDataTermsQuery:");
            return sb.append(field).append(":").append("[cacheKey=" + this.cacheKey + "]").toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKeyFieldDataTermsQuery)) {
                return false;
            }
            CacheKeyFieldDataTermsQuery other = (CacheKeyFieldDataTermsQuery)((Object)o);
            return super.equals(o) && this.cacheKey == other.cacheKey;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)this.cacheKey;
            return result;
        }
    }

    protected static class BytesFieldDataTermsQuery
    extends FieldDataTermsQuery {
        private final ESLogger logger = Loggers.getLogger(((Object)((Object)this)).getClass());

        public BytesFieldDataTermsQuery(byte[] encodedTerms, IndexFieldData fieldData, long cacheKey) {
            super(encodedTerms, fieldData, cacheKey);
        }

        public long ramBytesUsed() {
            NumericTermsSet termsSet = this.getTermsSet();
            return BASE_RAM_BYTES_USED + (long)(termsSet.size() * 8);
        }

        public String toString(String defaultField) {
            NumericTermsSet termsSet = this.getTermsSet();
            StringBuilder sb = new StringBuilder("BytesFieldDataTermsQuery:");
            return sb.append(defaultField).append(":").append("[size=" + termsSet.size() * 8 + "]").toString();
        }

        @Override
        public DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
            final NumericTermsSet termsSet = this.getTermsSet();
            if (termsSet == null || termsSet.isEmpty()) {
                return null;
            }
            final SortedBinaryDocValues values = this.fieldData.load(context).getBytesValues();
            return new DocValuesDocIdSet(context.reader().maxDoc(), context.reader().getLiveDocs()){

                protected boolean matchDoc(int doc) {
                    values.setDocument(doc);
                    int numVals = values.count();
                    for (int i = 0; i < numVals; ++i) {
                        BytesRef term = values.valueAt(i);
                        long termHash = LongBloomFilter.hash3_x64_128(term.bytes, term.offset, term.length, 0L);
                        if (!termsSet.contains(termHash)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    protected static class LongsFieldDataTermsQuery
    extends FieldDataTermsQuery {
        public LongsFieldDataTermsQuery(byte[] encodedTerms, IndexFieldData fieldData, long cacheKey) {
            super(encodedTerms, fieldData, cacheKey);
        }

        public long ramBytesUsed() {
            NumericTermsSet termsSet = this.getTermsSet();
            return BASE_RAM_BYTES_USED + (long)(termsSet.size() * 8);
        }

        public String toString(String defaultField) {
            NumericTermsSet termsSet = this.getTermsSet();
            StringBuilder sb = new StringBuilder("LongsFieldDataTermsQuery:");
            return sb.append(defaultField).append(":").append("[size=" + termsSet.size() + "]").toString();
        }

        @Override
        public DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
            final NumericTermsSet termsSet = this.getTermsSet();
            if (termsSet == null || termsSet.isEmpty()) {
                return null;
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)this.fieldData;
            if (!numericFieldData.getNumericType().isFloatingPoint()) {
                final SortedNumericDocValues values = ((AtomicNumericFieldData)numericFieldData.load(context)).getLongValues();
                return new DocValuesDocIdSet(context.reader().maxDoc(), context.reader().getLiveDocs()){

                    protected boolean matchDoc(int doc) {
                        values.setDocument(doc);
                        int numVals = values.count();
                        for (int i = 0; i < numVals; ++i) {
                            if (!termsSet.contains(values.valueAt(i))) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return null;
        }
    }
}

