/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.common;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import solutions.siren.join.action.terms.collector.BytesRefTermsSet;
import solutions.siren.join.action.terms.collector.LongTermsSet;

public class Bytes {
    public static final byte[] encode(long[] values) throws IOException {
        LongTermsSet termsSet = new LongTermsSet(values.length, (CircuitBreaker)new NoopCircuitBreaker("<term_set>"));
        for (int i = 0; i < values.length; ++i) {
            termsSet.add(values[i]);
        }
        return termsSet.writeToBytes().bytes;
    }

    public static final byte[] encode(BytesRef[] values) throws IOException {
        BytesRefTermsSet termsSet = new BytesRefTermsSet((CircuitBreaker)new NoopCircuitBreaker("<term_set>"));
        for (int i = 0; i < values.length; ++i) {
            termsSet.add(values[i]);
        }
        return termsSet.writeToBytes().bytes;
    }

    public static final void writeInt(BytesRef dst, int i) {
        dst.bytes[dst.offset] = (byte)(i >> 24);
        dst.bytes[dst.offset + 1] = (byte)(i >> 16);
        dst.bytes[dst.offset + 2] = (byte)(i >> 8);
        dst.bytes[dst.offset + 3] = (byte)i;
        dst.offset += 4;
    }

    public static final void writeVInt(BytesRef dst, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            dst.bytes[dst.offset++] = (byte)(i & 0x7F | 0x80);
            i >>>= 7;
        }
        dst.bytes[dst.offset++] = (byte)i;
    }

    public static final void writeLong(BytesRef dst, long i) {
        Bytes.writeInt(dst, (int)(i >> 32));
        Bytes.writeInt(dst, (int)i);
    }

    public static final int readInt(BytesRef src) {
        return (src.bytes[src.offset++] & 0xFF) << 24 | (src.bytes[src.offset++] & 0xFF) << 16 | (src.bytes[src.offset++] & 0xFF) << 8 | src.bytes[src.offset++] & 0xFF;
    }

    public static final int readVInt(BytesRef src) {
        byte b = src.bytes[src.offset++];
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = src.bytes[src.offset++];
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = src.bytes[src.offset++];
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = src.bytes[src.offset++];
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = src.bytes[src.offset++];
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public static final long readLong(BytesRef src) {
        return (long)Bytes.readInt(src) << 32 | (long)Bytes.readInt(src) & 0xFFFFFFFFL;
    }

    public static final void writeBytesRef(BytesRef src, BytesRef dst) {
        if (src == null) {
            Bytes.writeVInt(dst, 0);
            return;
        }
        Bytes.writeVInt(dst, src.length);
        System.arraycopy(src.bytes, src.offset, dst.bytes, dst.offset, src.length);
        dst.offset += src.length;
    }

    public static final void readBytesRef(BytesRef src, BytesRef dst) {
        int length = Bytes.readVInt(src);
        if (length == 0) {
            dst.length = 0;
            dst.offset = 0;
            return;
        }
        if (dst.bytes.length < length) {
            dst.bytes = new byte[length];
        }
        System.arraycopy(src.bytes, src.offset, dst.bytes, 0, length);
        src.offset += length;
        dst.offset = 0;
        dst.length = length;
    }
}

