/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.util.PriorityQueue;
import solutions.siren.join.action.terms.collector.HitStream;

public class TopHitStream
extends HitStream {
    private final int numHit;
    private ScoreDoc[] topHits;
    private int count = 0;
    private int currentAtomicReaderId = 0;
    private int currentAtomicDocId = -1;

    public TopHitStream(int numHit, Query query, IndexSearcher searcher) throws IOException {
        super(query, (Collector)new TopHitCollector(new HitQueue(numHit)), searcher);
        this.numHit = numHit;
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.topHits = ((TopHitCollector)this.getCollector()).topDocs().scoreDocs;
        Arrays.sort(this.topHits, new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc o1, ScoreDoc o2) {
                return ((ScoreHit)o1).atomicReaderId - ((ScoreHit)o2).atomicReaderId;
            }
        });
    }

    @Override
    public int getTotalHits() {
        return ((TopHitCollector)this.getCollector()).getTotalHits();
    }

    @Override
    public int getHits() {
        return this.topHits.length;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.getHits();
    }

    @Override
    public void next() {
        ScoreHit scoreHit = (ScoreHit)this.topHits[this.count];
        this.currentAtomicReaderId = scoreHit.atomicReaderId;
        this.currentAtomicDocId = scoreHit.doc;
        ++this.count;
    }

    @Override
    public int getAtomicDocId() {
        return this.currentAtomicDocId;
    }

    @Override
    public int getAtomicReaderId() {
        return this.currentAtomicReaderId;
    }

    private static class HitQueue
    extends PriorityQueue<ScoreHit> {
        HitQueue(int size) {
            super(size, true);
        }

        protected ScoreHit getSentinelObject() {
            return new ScoreHit(Integer.MAX_VALUE, Integer.MAX_VALUE, Float.NEGATIVE_INFINITY);
        }

        protected final boolean lessThan(ScoreHit hitA, ScoreHit hitB) {
            if (hitA.score == hitB.score) {
                return hitA.atomicReaderId > hitB.atomicReaderId & hitA.doc > hitB.doc;
            }
            return hitA.score < hitB.score;
        }
    }

    private static class ScoreHit
    extends ScoreDoc {
        public int atomicReaderId;

        public ScoreHit(int atomicReaderId, int docId, float score) {
            super(docId, score);
            this.atomicReaderId = atomicReaderId;
        }
    }

    private static class TopHitCollector
    extends TopDocsCollector<ScoreHit> {
        private int currentAtomicReaderId;
        private ScoreHit pqTop;

        public TopHitCollector(HitQueue hq) {
            super((PriorityQueue)hq);
            this.pqTop = (ScoreHit)((Object)this.pq.top());
        }

        public boolean needsScores() {
            return true;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.currentAtomicReaderId = context.ord;
            int docBase = context.docBase;
            return new LeafCollector(){
                Scorer scorer;

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score != Float.NEGATIVE_INFINITY);
                    assert (!Float.isNaN(score));
                    TopHitCollector.this.totalHits++;
                    if (score <= ((TopHitCollector)TopHitCollector.this).pqTop.score) {
                        return;
                    }
                    ((TopHitCollector)TopHitCollector.this).pqTop.atomicReaderId = TopHitCollector.this.currentAtomicReaderId;
                    ((TopHitCollector)TopHitCollector.this).pqTop.doc = doc;
                    ((TopHitCollector)TopHitCollector.this).pqTop.score = score;
                    TopHitCollector.this.pqTop = (ScoreHit)((Object)TopHitCollector.this.pq.updateTop());
                }
            };
        }
    }
}

