/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.BloomFilterTermsSet;
import solutions.siren.join.action.terms.collector.BytesRefTermsSet;
import solutions.siren.join.action.terms.collector.IntegerTermsSet;
import solutions.siren.join.action.terms.collector.LongTermsSet;
import solutions.siren.join.common.Bytes;

public abstract class TermsSet
implements Streamable {
    private boolean isPruned = false;
    protected final CircuitBreaker breaker;

    protected TermsSet(CircuitBreaker breaker) {
        this.breaker = breaker;
    }

    public void setIsPruned(boolean isPruned) {
        this.isPruned = isPruned;
    }

    public boolean isPruned() {
        return this.isPruned;
    }

    protected abstract void addAll(TermsSet var1);

    public void merge(TermsSet other) {
        this.addAll(other);
        this.isPruned |= other.isPruned;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public abstract void readFrom(StreamInput var1) throws IOException;

    public abstract void writeTo(StreamOutput var1) throws IOException;

    public abstract BytesRef writeToBytes();

    public abstract TermsByQueryRequest.TermsEncoding getEncoding();

    public abstract void release();

    public static TermsSet newTermsSet(long expectedElements, TermsByQueryRequest.TermsEncoding termsEncoding, CircuitBreaker breaker) {
        switch (termsEncoding) {
            case LONG: {
                return new LongTermsSet(expectedElements, breaker);
            }
            case INTEGER: {
                return new IntegerTermsSet(expectedElements, breaker);
            }
            case BLOOM: {
                return new BloomFilterTermsSet(expectedElements, breaker);
            }
            case BYTES: {
                return new BytesRefTermsSet(breaker);
            }
        }
        throw new IllegalArgumentException("[termsByQuery] Invalid terms encoding: " + termsEncoding.name());
    }

    public static TermsSet readFrom(BytesRef in) {
        TermsByQueryRequest.TermsEncoding termsEncoding = TermsByQueryRequest.TermsEncoding.values()[Bytes.readInt(in)];
        switch (termsEncoding) {
            case INTEGER: {
                return new IntegerTermsSet(in);
            }
            case LONG: {
                return new LongTermsSet(in);
            }
            case BLOOM: {
                return new BloomFilterTermsSet(in);
            }
            case BYTES: {
                return new BytesRefTermsSet(in);
            }
        }
        throw new IllegalArgumentException("[termsByQuery] Invalid terms encoding: " + termsEncoding.name());
    }
}

