/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.search.internal.SearchContext;
import solutions.siren.join.action.terms.collector.HitStream;
import solutions.siren.join.action.terms.collector.TermsSet;
import solutions.siren.join.common.Math;

public abstract class TermsCollector {
    protected final SearchContext context;
    protected final IndexFieldData indexFieldData;
    protected final CircuitBreaker breaker;
    protected int expectedTerms = -1;
    protected int maxTerms = Integer.MAX_VALUE;

    public TermsCollector(IndexFieldData indexFieldData, SearchContext context, CircuitBreaker breaker) {
        this.indexFieldData = indexFieldData;
        this.context = context;
        this.breaker = breaker;
    }

    public void setExpectedTerms(long expectedTerms) {
        this.expectedTerms = Math.toIntExact(expectedTerms);
    }

    public void setMaxTerms(int maxTerms) {
        this.maxTerms = maxTerms;
    }

    public abstract TermsSet collect(HitStream var1) throws IOException;
}

