/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.search.internal.SearchContext;
import solutions.siren.join.action.terms.collector.HitStream;
import solutions.siren.join.action.terms.collector.NumericTermStream;
import solutions.siren.join.action.terms.collector.NumericTermsSet;
import solutions.siren.join.action.terms.collector.TermsCollector;

public abstract class NumericTermsCollector
extends TermsCollector {
    public NumericTermsCollector(IndexFieldData indexFieldData, SearchContext context, CircuitBreaker breaker) {
        super(indexFieldData, context, breaker);
    }

    protected abstract NumericTermsSet newTermsSet(int var1, CircuitBreaker var2);

    @Override
    public NumericTermsSet collect(HitStream hitStream) throws IOException {
        hitStream.initialize();
        int nHits = hitStream.getHits();
        NumericTermsSet terms = this.newTermsSet(this.expectedTerms != -1 ? this.expectedTerms : nHits, this.breaker);
        try {
            NumericTermStream reusableTermStream = NumericTermStream.get(this.context.searcher().getIndexReader(), this.indexFieldData);
            while (terms.size() < this.maxTerms && hitStream.hasNext()) {
                hitStream.next();
                reusableTermStream = hitStream.getTermStream(reusableTermStream);
                while (terms.size() < this.maxTerms && reusableTermStream.hasNext()) {
                    terms.add(reusableTermStream.next());
                }
            }
            boolean isPruned = hitStream.getTotalHits() > hitStream.getHits();
            terms.setIsPruned(isPruned |= this.maxTerms < nHits);
            return terms;
        }
        catch (Throwable t) {
            terms.release();
            throw t;
        }
    }
}

