/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import solutions.siren.join.action.terms.collector.LongBloomFilter;
import solutions.siren.join.action.terms.collector.TermStream;

abstract class NumericTermStream
extends TermStream {
    public static NumericTermStream get(IndexReader reader, IndexFieldData indexFieldData) {
        if (indexFieldData instanceof IndexNumericFieldData) {
            IndexNumericFieldData numFieldData = (IndexNumericFieldData)indexFieldData;
            if (!numFieldData.getNumericType().isFloatingPoint()) {
                return new LongTermStream(reader, numFieldData);
            }
            throw new UnsupportedOperationException("Streaming floating points is unsupported");
        }
        return new HashTermStream(reader, indexFieldData);
    }

    protected NumericTermStream(IndexReader reader) {
        super(reader);
    }

    public abstract boolean hasNext();

    public abstract long next();

    @Override
    protected abstract void set(int var1, int var2);

    private static class HashTermStream
    extends NumericTermStream {
        private final IndexFieldData fieldData;
        private int lastAtomicReaderId = -1;
        private SortedBinaryDocValues values;
        private int count;

        protected HashTermStream(IndexReader reader, IndexFieldData fieldData) {
            super(reader);
            this.fieldData = fieldData;
        }

        @Override
        protected void set(int atomicReaderId, int atomicDocId) {
            if (this.lastAtomicReaderId != atomicReaderId) {
                LeafReaderContext leafReader = (LeafReaderContext)this.reader.leaves().get(atomicReaderId);
                this.values = this.fieldData.load(leafReader).getBytesValues();
            }
            this.values.setDocument(atomicDocId);
            this.count = 0;
            this.lastAtomicReaderId = atomicReaderId;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.values.count();
        }

        @Override
        public long next() {
            BytesRef term = this.values.valueAt(this.count++);
            return LongBloomFilter.hash3_x64_128(term.bytes, term.offset, term.length, 0L);
        }
    }

    private static class LongTermStream
    extends NumericTermStream {
        private final IndexNumericFieldData fieldData;
        private int lastAtomicReaderId = -1;
        private SortedNumericDocValues values;
        private int count;

        protected LongTermStream(IndexReader reader, IndexNumericFieldData fieldData) {
            super(reader);
            this.fieldData = fieldData;
        }

        @Override
        protected void set(int atomicReaderId, int atomicDocId) {
            if (this.lastAtomicReaderId != atomicReaderId) {
                LeafReaderContext leafReader = (LeafReaderContext)this.reader.leaves().get(atomicReaderId);
                this.values = ((AtomicNumericFieldData)this.fieldData.load(leafReader)).getLongValues();
            }
            this.values.setDocument(atomicDocId);
            this.count = 0;
            this.lastAtomicReaderId = atomicReaderId;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.values.count();
        }

        @Override
        public long next() {
            return this.values.valueAt(this.count++);
        }
    }
}

