/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongScatterSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.NumericTermsSet;
import solutions.siren.join.action.terms.collector.TermsSet;
import solutions.siren.join.common.Bytes;
import solutions.siren.join.common.Math;

public class LongTermsSet
extends NumericTermsSet {
    private transient LongHashSet set;
    private static final int HEADER_SIZE = 9;
    private static final ESLogger logger = Loggers.getLogger(LongTermsSet.class);

    public LongTermsSet(CircuitBreaker breaker) {
        super(breaker);
    }

    @Override
    protected void addAll(TermsSet terms) {
        if (!(terms instanceof LongTermsSet)) {
            throw new UnsupportedOperationException("Invalid type: LongTermSet expected.");
        }
        this.set.addAll((LongContainer)((LongTermsSet)terms).set);
    }

    public LongTermsSet(long expectedElements, CircuitBreaker breakerService) {
        super(breakerService);
        this.set = new CircuitBreakerLongHashSet(Math.toIntExact(expectedElements));
    }

    public LongTermsSet(BytesRef bytes) {
        super(null);
        this.readFromBytes(bytes);
    }

    public LongHashSet getLongHashSet() {
        return this.set;
    }

    @Override
    public void add(long term) {
        this.set.add(term);
    }

    @Override
    public boolean contains(long term) {
        return this.set.contains(term);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.setIsPruned(in.readBoolean());
        int size = in.readInt();
        this.set = new CircuitBreakerLongHashSet(size);
        for (long i = 0L; i < (long)size; ++i) {
            this.set.add(in.readLong());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPruned());
        out.writeInt(this.set.size());
        BytesRef buffer = new BytesRef(new byte[8192]);
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            Bytes.writeLong(buffer, ((LongCursor)it.next()).value);
            if (buffer.offset != buffer.length) continue;
            out.write(buffer.bytes, 0, buffer.offset);
            buffer.offset = 0;
        }
        out.write(buffer.bytes, 0, buffer.offset);
    }

    @Override
    public BytesRef writeToBytes() {
        long start = System.nanoTime();
        int size = this.set.size();
        BytesRef bytes = new BytesRef(new byte[9 + 8 * size]);
        Bytes.writeInt(bytes, this.getEncoding().ordinal());
        bytes.bytes[bytes.offset++] = (byte)(this.isPruned() ? 1 : 0);
        Bytes.writeInt(bytes, size);
        for (LongCursor i : this.set) {
            Bytes.writeLong(bytes, i.value);
        }
        logger.debug("Serialized {} terms - took {} ms", new Object[]{this.size(), (System.nanoTime() - start) / 1000000L});
        bytes.length = bytes.offset;
        bytes.offset = 0;
        return bytes;
    }

    private void readFromBytes(BytesRef bytes) {
        this.setIsPruned(bytes.bytes[bytes.offset++] == 1);
        int size = Bytes.readInt(bytes);
        this.set = new LongScatterSet(size);
        for (int i = 0; i < size; ++i) {
            this.set.add(Bytes.readLong(bytes));
        }
    }

    @Override
    public TermsByQueryRequest.TermsEncoding getEncoding() {
        return TermsByQueryRequest.TermsEncoding.LONG;
    }

    @Override
    public void release() {
        if (this.set != null) {
            this.set.release();
        }
    }

    private final class CircuitBreakerLongHashSet
    extends LongHashSet {
        public CircuitBreakerLongHashSet(int expectedElements) {
            super(expectedElements);
        }

        protected void allocateBuffers(int arraySize) {
            long newMemSize = (long)(arraySize + 1) * 8L;
            long oldMemSize = this.keys == null ? 0L : (long)this.keys.length * 8L;
            LongTermsSet.this.breaker.addEstimateBytesAndMaybeBreak(newMemSize, "<terms_set>");
            try {
                super.allocateBuffers(arraySize);
                LongTermsSet.this.breaker.addWithoutBreaking(-oldMemSize);
            }
            catch (BufferAllocationException e) {
                LongTermsSet.this.breaker.addWithoutBreaking(-newMemSize);
                throw e;
            }
        }

        public void release() {
            long memSize = this.keys == null ? 0L : (long)this.keys.length * 8L;
            this.assigned = 0;
            this.hasEmptyKey = false;
            this.keys = null;
            LongTermsSet.this.breaker.addWithoutBreaking(-memSize);
        }
    }
}

