/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;

public class LongBloomFilter {
    final BitArray bits;
    final int numHashFunctions;
    final Hashing hashing;

    public LongBloomFilter(int expectedInsertions, double fpp) {
        this(expectedInsertions, fpp, -1);
    }

    LongBloomFilter(int expectedInsertions, double fpp, int numHashFunctions) {
        if (expectedInsertions == 0) {
            expectedInsertions = 1;
        }
        long numBits = LongBloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        this.bits = this.createBitArray(numBits);
        if (numHashFunctions == -1) {
            numHashFunctions = LongBloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        }
        this.numHashFunctions = numHashFunctions;
        this.hashing = Hashing.DEFAULT;
        if (numHashFunctions > 255) {
            throw new IllegalArgumentException("Currently we don't allow BloomFilters that would use more than 255 hash functions");
        }
    }

    LongBloomFilter(BitArray bits, int numHashFunctions, Hashing hashing) {
        this.bits = bits;
        this.numHashFunctions = numHashFunctions;
        this.hashing = hashing;
    }

    protected BitArray createBitArray(long numBits) {
        return new BitArray(numBits);
    }

    protected void release() {
        this.bits.data = new long[0];
        this.bits.bitSize = 0L;
        this.bits.bitCount = 0L;
    }

    public boolean put(long hash64) {
        return this.hashing.put(hash64, this.numHashFunctions, this.bits);
    }

    public void merge(LongBloomFilter other) {
        if (this.bits.data.length != other.bits.data.length || this.numHashFunctions != other.getNumHashFunctions() || this.hashing.type() != other.hashing.type()) {
            throw new IllegalArgumentException("BloomFilters must have same size, number of hash functions, and hash type");
        }
        this.bits.putAll(other.bits);
    }

    public boolean mightContain(long hash64) {
        return this.hashing.mightContain(hash64, this.numHashFunctions, this.bits);
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public int getSizeInBytes() {
        return this.bits.ramBytesUsed();
    }

    public int estimateCardinality() {
        double t = this.bits.bitCount();
        double m = this.bits.bitSize();
        double k = this.numHashFunctions;
        double x = Math.log(1.0 - t / m);
        double y = k * Math.log(1.0 - 1.0 / m);
        return (int)Math.ceil(x / y);
    }

    public int hashCode() {
        return this.bits.hashCode() + this.numHashFunctions;
    }

    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)(m / n) * Math.log(2.0)));
    }

    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    protected static long getblock(byte[] key, int offset, int index) {
        int i_8 = index << 3;
        int blockOffset = offset + i_8;
        return ((long)key[blockOffset + 0] & 0xFFL) + (((long)key[blockOffset + 1] & 0xFFL) << 8) + (((long)key[blockOffset + 2] & 0xFFL) << 16) + (((long)key[blockOffset + 3] & 0xFFL) << 24) + (((long)key[blockOffset + 4] & 0xFFL) << 32) + (((long)key[blockOffset + 5] & 0xFFL) << 40) + (((long)key[blockOffset + 6] & 0xFFL) << 48) + (((long)key[blockOffset + 7] & 0xFFL) << 56);
    }

    protected static long rotl64(long v, int n) {
        return v << n | v >>> 64 - n;
    }

    protected static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long hash3_x64_128(byte[] key, int offset, int length, long seed) {
        int nblocks = length >> 4;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = LongBloomFilter.getblock(key, offset, i * 2 + 0);
            long k2 = LongBloomFilter.getblock(key, offset, i * 2 + 1);
            k1 *= c1;
            k1 = LongBloomFilter.rotl64(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = LongBloomFilter.rotl64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = LongBloomFilter.rotl64(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = LongBloomFilter.rotl64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset += nblocks * 16;
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)key[offset + 14] << 48;
            }
            case 14: {
                k2 ^= (long)key[offset + 13] << 40;
            }
            case 13: {
                k2 ^= (long)key[offset + 12] << 32;
            }
            case 12: {
                k2 ^= (long)key[offset + 11] << 24;
            }
            case 11: {
                k2 ^= (long)key[offset + 10] << 16;
            }
            case 10: {
                k2 ^= (long)key[offset + 9] << 8;
            }
            case 9: {
                k2 ^= (long)key[offset + 8] << 0;
                k2 *= c2;
                k2 = LongBloomFilter.rotl64(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)key[offset + 7] << 56;
            }
            case 7: {
                k1 ^= (long)key[offset + 6] << 48;
            }
            case 6: {
                k1 ^= (long)key[offset + 5] << 40;
            }
            case 5: {
                k1 ^= (long)key[offset + 4] << 32;
            }
            case 4: {
                k1 ^= (long)key[offset + 3] << 24;
            }
            case 3: {
                k1 ^= (long)key[offset + 2] << 16;
            }
            case 2: {
                k1 ^= (long)key[offset + 1] << 8;
            }
            case 1: {
                k1 ^= (long)key[offset];
                k1 *= c1;
                k1 = LongBloomFilter.rotl64(k1, 31);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = LongBloomFilter.fmix(h1);
        h2 = LongBloomFilter.fmix(h2);
        h1 += h2;
        h2 += h1;
        return h1;
    }

    static enum Hashing {
        V0{

            @Override
            protected boolean put(long hash64, int numHashFunctions, BitArray bits) {
                long bitSize = bits.bitSize();
                int hash1 = (int)hash64;
                int hash2 = (int)(hash64 >>> 32);
                boolean bitsChanged = false;
                long combinedHash = hash1;
                for (int i = 1; i <= numHashFunctions; ++i) {
                    bitsChanged |= bits.set((combinedHash & Long.MAX_VALUE) % bitSize);
                    combinedHash += (long)hash2;
                }
                return bitsChanged;
            }

            @Override
            protected boolean mightContain(long hash64, int numHashFunctions, BitArray bits) {
                long bitSize = bits.bitSize();
                int hash1 = (int)hash64;
                int hash2 = (int)(hash64 >>> 32);
                long combinedHash = hash1;
                for (int i = 1; i <= numHashFunctions; ++i) {
                    if (!bits.get((combinedHash & Long.MAX_VALUE) % bitSize)) {
                        return false;
                    }
                    combinedHash += (long)hash2;
                }
                return true;
            }

            @Override
            protected int type() {
                return 0;
            }
        };

        public static final Hashing DEFAULT;

        protected abstract boolean put(long var1, int var3, BitArray var4);

        protected abstract boolean mightContain(long var1, int var3, BitArray var4);

        protected abstract int type();

        public static Hashing fromType(int type) {
            if (type == 0) {
                return V0;
            }
            throw new IllegalArgumentException("no hashing type matching " + type);
        }

        static {
            DEFAULT = V0;
        }
    }

    static final class BitArray {
        long[] data;
        long bitSize;
        long bitCount;

        BitArray(long bits) {
            this(new long[Ints.checkedCast((long)LongMath.divide((long)bits, (long)64L, (RoundingMode)RoundingMode.CEILING))]);
        }

        BitArray(long[] data) {
            this.data = data;
            long bitCount = 0L;
            for (long value : data) {
                bitCount += (long)Long.bitCount(value);
            }
            this.bitCount = bitCount;
            this.bitSize = data.length * 64;
        }

        boolean set(long index) {
            if (!this.get(index)) {
                int n = (int)(index >>> 6);
                this.data[n] = this.data[n] | 1L << (int)index;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        boolean get(long index) {
            return (this.data[(int)(index >>> 6)] & 1L << (int)index) != 0L;
        }

        long bitSize() {
            return this.bitSize;
        }

        long bitCount() {
            return this.bitCount;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        void putAll(BitArray array) {
            this.bitCount = 0L;
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array.data[i];
                this.bitCount += (long)Long.bitCount(this.data[i]);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }

        public int ramBytesUsed() {
            return 8 * this.data.length + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 16;
        }
    }
}

