/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.NumericTermsSet;
import solutions.siren.join.action.terms.collector.TermsSet;
import solutions.siren.join.common.Bytes;
import solutions.siren.join.common.Math;

public class IntegerTermsSet
extends NumericTermsSet {
    private transient IntHashSet set;
    private static final int HEADER_SIZE = 9;
    private static final ESLogger logger = Loggers.getLogger(IntegerTermsSet.class);

    public IntegerTermsSet(CircuitBreaker breaker) {
        super(breaker);
    }

    public IntegerTermsSet(long expectedElements, CircuitBreaker breaker) {
        super(breaker);
        this.set = new CircuitBreakerIntHashSet(Math.toIntExact(expectedElements));
    }

    public IntegerTermsSet(BytesRef bytes) {
        super(null);
        this.readFromBytes(bytes);
    }

    @Override
    public void add(long term) {
        this.set.add((int)term);
    }

    @Override
    public boolean contains(long term) {
        return this.set.contains((int)term);
    }

    @Override
    protected void addAll(TermsSet terms) {
        if (!(terms instanceof IntegerTermsSet)) {
            throw new UnsupportedOperationException("Invalid type: IntegerTermsSet expected.");
        }
        this.set.addAll((IntContainer)((IntegerTermsSet)terms).set);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.setIsPruned(in.readBoolean());
        int size = in.readInt();
        this.set = new CircuitBreakerIntHashSet(size);
        for (long i = 0L; i < (long)size; ++i) {
            this.set.add(in.readVInt());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPruned());
        out.writeInt(this.set.size());
        BytesRef buffer = new BytesRef(new byte[8192]);
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            Bytes.writeVInt(buffer, ((IntCursor)it.next()).value);
            if (buffer.offset <= buffer.bytes.length - 5) continue;
            out.write(buffer.bytes, 0, buffer.offset);
            buffer.offset = 0;
        }
        out.write(buffer.bytes, 0, buffer.offset);
    }

    @Override
    public BytesRef writeToBytes() {
        long start = System.nanoTime();
        int size = this.set.size();
        BytesRef bytesRef = new BytesRef(new byte[9 + size * 5]);
        Bytes.writeInt(bytesRef, this.getEncoding().ordinal());
        bytesRef.bytes[bytesRef.offset++] = (byte)(this.isPruned() ? 1 : 0);
        Bytes.writeInt(bytesRef, size);
        for (IntCursor i : this.set) {
            Bytes.writeVInt(bytesRef, i.value);
        }
        logger.debug("Serialized {} terms - took {} ms", new Object[]{this.size(), (System.nanoTime() - start) / 1000000L});
        bytesRef.length = bytesRef.offset;
        bytesRef.offset = 0;
        return bytesRef;
    }

    private void readFromBytes(BytesRef bytesRef) {
        this.setIsPruned(bytesRef.bytes[bytesRef.offset++] == 1);
        int size = Bytes.readInt(bytesRef);
        this.set = new IntScatterSet(size);
        for (int i = 0; i < size; ++i) {
            this.set.add(Bytes.readVInt(bytesRef));
        }
    }

    @Override
    public TermsByQueryRequest.TermsEncoding getEncoding() {
        return TermsByQueryRequest.TermsEncoding.INTEGER;
    }

    @Override
    public void release() {
        if (this.set != null) {
            this.set.release();
        }
    }

    private final class CircuitBreakerIntHashSet
    extends IntHashSet {
        public CircuitBreakerIntHashSet(int expectedElements) {
            super(expectedElements);
        }

        protected void allocateBuffers(int arraySize) {
            long newMemSize = (long)(arraySize + 1) * 4L;
            long oldMemSize = this.keys == null ? 0L : (long)this.keys.length * 4L;
            IntegerTermsSet.this.breaker.addEstimateBytesAndMaybeBreak(newMemSize, "<terms_set>");
            try {
                super.allocateBuffers(arraySize);
                IntegerTermsSet.this.breaker.addWithoutBreaking(-oldMemSize);
            }
            catch (BufferAllocationException e) {
                IntegerTermsSet.this.breaker.addWithoutBreaking(-newMemSize);
            }
        }

        public void release() {
            long memSize = this.keys == null ? 0L : (long)this.keys.length * 4L;
            this.assigned = 0;
            this.hasEmptyKey = false;
            this.keys = null;
            IntegerTermsSet.this.breaker.addWithoutBreaking(-memSize);
        }
    }
}

