/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import solutions.siren.join.action.terms.collector.TermStream;

public abstract class HitStream {
    private final Query query;
    protected final IndexSearcher searcher;
    private final Collector collector;

    public HitStream(Query query, Collector collector, IndexSearcher searcher) throws IOException {
        this.query = query;
        this.searcher = searcher;
        this.collector = collector;
    }

    public void initialize() throws IOException {
        this.searcher.search(this.query, this.collector);
    }

    public abstract int getTotalHits();

    public abstract int getHits();

    protected Collector getCollector() {
        return this.collector;
    }

    public abstract boolean hasNext();

    public abstract void next();

    protected abstract int getAtomicDocId();

    protected abstract int getAtomicReaderId();

    public <T extends TermStream> T getTermStream(T reusableTermStream) {
        reusableTermStream.set(this.getAtomicReaderId(), this.getAtomicDocId());
        return reusableTermStream;
    }
}

