/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.TermsSet;
import solutions.siren.join.common.Bytes;

public class BytesRefTermsSet
extends TermsSet {
    private transient Counter bytesUsed;
    private transient ByteBlockPool pool;
    private transient BytesRefHash set;
    private static final int HEADER_SIZE = 9;
    private static final ESLogger logger = Loggers.getLogger(BytesRefTermsSet.class);

    public BytesRefTermsSet(CircuitBreaker breaker) {
        super(breaker);
        this.bytesUsed = Counter.newCounter();
        this.pool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        this.set = new BytesRefHash(this.pool);
    }

    public BytesRefTermsSet(BytesRef bytes) {
        super(null);
        this.readFromBytes(bytes);
    }

    public void add(BytesRef term) {
        this.set.add(term);
    }

    public boolean contains(BytesRef term) {
        return this.set.find(term) != -1;
    }

    @Override
    protected void addAll(TermsSet terms) {
        if (!(terms instanceof BytesRefTermsSet)) {
            throw new UnsupportedOperationException("Invalid type: BytesRefTermsSet expected.");
        }
        BytesRefHash input = ((BytesRefTermsSet)terms).set;
        BytesRef reusable = new BytesRef();
        for (int i = 0; i < input.size(); ++i) {
            input.get(i, reusable);
            this.set.add(reusable);
        }
    }

    public BytesRefHash getBytesRefHash() {
        return this.set;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.setIsPruned(in.readBoolean());
        int size = in.readInt();
        this.bytesUsed = Counter.newCounter();
        this.pool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        this.set = new BytesRefHash(this.pool);
        for (long i = 0L; i < (long)size; ++i) {
            this.set.add(in.readBytesRef());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPruned());
        out.writeInt(this.set.size());
        BytesRef reusable = new BytesRef();
        for (int i = 0; i < this.set.size(); ++i) {
            this.set.get(i, reusable);
            out.writeBytesRef(reusable);
        }
    }

    @Override
    public BytesRef writeToBytes() {
        long start = System.nanoTime();
        int size = this.set.size();
        BytesRef bytes = new BytesRef(new byte[9 + (int)this.bytesUsed.get()]);
        Bytes.writeInt(bytes, this.getEncoding().ordinal());
        bytes.bytes[bytes.offset++] = (byte)(this.isPruned() ? 1 : 0);
        Bytes.writeInt(bytes, size);
        BytesRef reusable = new BytesRef();
        for (int i = 0; i < this.set.size(); ++i) {
            this.set.get(i, reusable);
            Bytes.writeBytesRef(reusable, bytes);
        }
        logger.debug("Serialized {} terms - took {} ms", new Object[]{this.size(), (System.nanoTime() - start) / 1000000L});
        bytes.length = bytes.offset;
        bytes.offset = 0;
        return bytes;
    }

    private void readFromBytes(BytesRef bytes) {
        this.setIsPruned(bytes.bytes[bytes.offset++] == 1);
        int size = Bytes.readInt(bytes);
        this.bytesUsed = Counter.newCounter();
        this.pool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        this.set = new BytesRefHash(this.pool);
        BytesRef reusable = new BytesRef();
        for (int i = 0; i < size; ++i) {
            Bytes.readBytesRef(bytes, reusable);
            this.set.add(reusable);
        }
    }

    @Override
    public TermsByQueryRequest.TermsEncoding getEncoding() {
        return TermsByQueryRequest.TermsEncoding.BYTES;
    }

    @Override
    public void release() {
        if (this.set != null) {
            this.set.close();
        }
    }
}

