/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import java.io.IOException;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.search.internal.SearchContext;
import solutions.siren.join.action.terms.collector.BytesRefTermStream;
import solutions.siren.join.action.terms.collector.BytesRefTermsSet;
import solutions.siren.join.action.terms.collector.HitStream;
import solutions.siren.join.action.terms.collector.TermsCollector;
import solutions.siren.join.action.terms.collector.TermsSet;

public class BytesRefTermsCollector
extends TermsCollector {
    public BytesRefTermsCollector(IndexFieldData indexFieldData, SearchContext context, CircuitBreaker breaker) {
        super(indexFieldData, context, breaker);
    }

    @Override
    public TermsSet collect(HitStream hitStream) throws IOException {
        hitStream.initialize();
        int nHits = hitStream.getHits();
        BytesRefTermsSet terms = new BytesRefTermsSet(this.breaker);
        try {
            BytesRefTermStream reusableTermStream = BytesRefTermStream.get(this.context.searcher().getIndexReader(), this.indexFieldData);
            while (terms.size() < this.maxTerms && hitStream.hasNext()) {
                hitStream.next();
                reusableTermStream = hitStream.getTermStream(reusableTermStream);
                while (terms.size() < this.maxTerms && reusableTermStream.hasNext()) {
                    terms.add(reusableTermStream.next());
                }
            }
            boolean isPruned = hitStream.getTotalHits() > hitStream.getHits();
            terms.setIsPruned(isPruned |= this.maxTerms < nHits);
            return terms;
        }
        catch (Throwable t) {
            terms.release();
            throw t;
        }
    }
}

