/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import solutions.siren.join.action.terms.collector.TermStream;

abstract class BytesRefTermStream
extends TermStream {
    protected final IndexFieldData fieldData;

    protected BytesRefTermStream(IndexReader reader, IndexFieldData indexFieldData) {
        super(reader);
        this.fieldData = indexFieldData;
    }

    public abstract boolean hasNext();

    public abstract BytesRef next();

    @Override
    protected abstract void set(int var1, int var2);

    public static BytesRefTermStream get(IndexReader reader, IndexFieldData indexFieldData) {
        if (indexFieldData instanceof IndexNumericFieldData) {
            IndexNumericFieldData numFieldData = (IndexNumericFieldData)indexFieldData;
            switch (numFieldData.getNumericType()) {
                case INT: {
                    return new IntegerBytesRefTermStream(reader, (IndexFieldData)numFieldData);
                }
                case LONG: {
                    return new LongBytesRefTermStream(reader, (IndexFieldData)numFieldData);
                }
            }
            throw new UnsupportedOperationException("Streaming numeric type '" + numFieldData.getNumericType().name() + "' is unsupported");
        }
        return new BytesBytesRefTermStream(reader, indexFieldData);
    }

    private static class LongBytesRefTermStream
    extends NumericBytesRefTermStream {
        protected LongBytesRefTermStream(IndexReader reader, IndexFieldData indexFieldData) {
            super(reader, indexFieldData);
        }

        @Override
        public BytesRef next() {
            BytesRefBuilder b = new BytesRefBuilder();
            NumericUtils.longToPrefixCoded((long)((int)this.values.valueAt(this.count++)), (int)0, (BytesRefBuilder)b);
            return b.toBytesRef();
        }
    }

    private static class IntegerBytesRefTermStream
    extends NumericBytesRefTermStream {
        protected IntegerBytesRefTermStream(IndexReader reader, IndexFieldData indexFieldData) {
            super(reader, indexFieldData);
        }

        @Override
        public BytesRef next() {
            BytesRefBuilder b = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)((int)this.values.valueAt(this.count++)), (int)0, (BytesRefBuilder)b);
            return b.toBytesRef();
        }
    }

    private static abstract class NumericBytesRefTermStream
    extends BytesRefTermStream {
        private int lastAtomicReaderId = -1;
        protected SortedNumericDocValues values;
        protected int count;

        protected NumericBytesRefTermStream(IndexReader reader, IndexFieldData indexFieldData) {
            super(reader, indexFieldData);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.values.count();
        }

        @Override
        protected void set(int atomicReaderId, int atomicDocId) {
            if (this.lastAtomicReaderId != atomicReaderId) {
                LeafReaderContext leafReader = (LeafReaderContext)this.reader.leaves().get(atomicReaderId);
                this.values = ((AtomicNumericFieldData)((IndexNumericFieldData)this.fieldData).load(leafReader)).getLongValues();
            }
            this.values.setDocument(atomicDocId);
            this.count = 0;
            this.lastAtomicReaderId = atomicReaderId;
        }
    }

    private static class BytesBytesRefTermStream
    extends BytesRefTermStream {
        private int lastAtomicReaderId = -1;
        private SortedBinaryDocValues values;
        private int count;

        protected BytesBytesRefTermStream(IndexReader reader, IndexFieldData indexFieldData) {
            super(reader, indexFieldData);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.values.count();
        }

        @Override
        public BytesRef next() {
            return this.values.valueAt(this.count++);
        }

        @Override
        protected void set(int atomicReaderId, int atomicDocId) {
            if (this.lastAtomicReaderId != atomicReaderId) {
                LeafReaderContext leafReader = (LeafReaderContext)this.reader.leaves().get(atomicReaderId);
                this.values = this.fieldData.load(leafReader).getBytesValues();
            }
            this.values.setDocument(atomicDocId);
            this.count = 0;
            this.lastAtomicReaderId = atomicReaderId;
        }
    }
}

