/*
 * Decompiled with CFR 0.152.
 */
package solutions.siren.join.action.terms.collector;

import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.math.RoundingMode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import solutions.siren.join.action.terms.TermsByQueryRequest;
import solutions.siren.join.action.terms.collector.LongBloomFilter;
import solutions.siren.join.action.terms.collector.NumericTermsSet;
import solutions.siren.join.action.terms.collector.TermsSet;
import solutions.siren.join.common.Bytes;
import solutions.siren.join.common.Math;

public class BloomFilterTermsSet
extends NumericTermsSet {
    private transient LongBloomFilter set;
    private static final double DEFAULT_FPP = 0.03;
    private static final int HEADER_SIZE = 17;
    private static final ESLogger logger = Loggers.getLogger(BloomFilterTermsSet.class);

    public BloomFilterTermsSet(CircuitBreaker breaker) {
        super(breaker);
    }

    public BloomFilterTermsSet(long expectedElements, CircuitBreaker breakerService) {
        super(breakerService);
        this.set = new CircuitBreakerLongBloomFilter(Math.toIntExact(expectedElements), 0.03);
    }

    public BloomFilterTermsSet(BytesRef bytes) {
        super(null);
        this.readFromBytes(bytes);
    }

    @Override
    public void add(long term) {
        this.set.put(term);
    }

    @Override
    public boolean contains(long term) {
        return this.set.mightContain(term);
    }

    @Override
    protected void addAll(TermsSet terms) {
        if (!(terms instanceof BloomFilterTermsSet)) {
            throw new UnsupportedOperationException("Invalid type: BloomFilterTermsSet expected.");
        }
        this.set.merge(((BloomFilterTermsSet)terms).set);
    }

    @Override
    public int size() {
        return this.set.estimateCardinality();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.setIsPruned(in.readBoolean());
        int numberOfHashFunctions = in.readVInt();
        int hashType = in.readVInt();
        int numLongs = in.readVInt();
        long memSize = numLongs * 8;
        this.breaker.addEstimateBytesAndMaybeBreak(memSize, "<terms_set>");
        try {
            long[] data = new long[numLongs];
            for (int i = 0; i < numLongs; ++i) {
                data[i] = in.readLong();
            }
            this.set = new CircuitBreakerLongBloomFilter(new LongBloomFilter.BitArray(data), numberOfHashFunctions, LongBloomFilter.Hashing.fromType(hashType));
        }
        catch (OutOfMemoryError e) {
            this.breaker.addWithoutBreaking(-memSize);
            throw e;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPruned());
        out.writeVInt(this.set.numHashFunctions);
        out.writeVInt(this.set.hashing.type());
        out.writeVInt(this.set.bits.data.length);
        BytesRef buffer = new BytesRef(new byte[8192]);
        for (long l : this.set.bits.data) {
            Bytes.writeLong(buffer, l);
            if (buffer.offset != buffer.length) continue;
            out.write(buffer.bytes, 0, buffer.offset);
            buffer.offset = 0;
        }
        out.write(buffer.bytes, 0, buffer.offset);
    }

    @Override
    public BytesRef writeToBytes() {
        long start = System.nanoTime();
        BytesRef bytes = new BytesRef(new byte[17 + this.set.bits.data.length * 8]);
        Bytes.writeInt(bytes, this.getEncoding().ordinal());
        bytes.bytes[bytes.offset++] = (byte)(this.isPruned() ? 1 : 0);
        Bytes.writeInt(bytes, this.set.numHashFunctions);
        Bytes.writeInt(bytes, this.set.hashing.type());
        Bytes.writeInt(bytes, this.set.bits.data.length);
        for (long l : this.set.bits.data) {
            Bytes.writeLong(bytes, l);
        }
        logger.debug("Serialized {} terms - took {} ms", new Object[]{this.size(), (System.nanoTime() - start) / 1000000L});
        bytes.length = bytes.offset;
        bytes.offset = 0;
        return bytes;
    }

    private void readFromBytes(BytesRef bytes) {
        this.setIsPruned(bytes.bytes[bytes.offset++] == 1);
        int numberOfHashFunctions = Bytes.readInt(bytes);
        int hashType = Bytes.readInt(bytes);
        int numLongs = Bytes.readInt(bytes);
        long[] data = new long[numLongs];
        for (int i = 0; i < numLongs; ++i) {
            data[i] = Bytes.readLong(bytes);
        }
        this.set = new LongBloomFilter(new LongBloomFilter.BitArray(data), numberOfHashFunctions, LongBloomFilter.Hashing.fromType(hashType));
    }

    @Override
    public TermsByQueryRequest.TermsEncoding getEncoding() {
        return TermsByQueryRequest.TermsEncoding.BLOOM;
    }

    @Override
    public void release() {
        if (this.set != null) {
            this.set.release();
        }
    }

    private final class CircuitBreakerLongBloomFilter
    extends LongBloomFilter {
        CircuitBreakerLongBloomFilter(int expectedInsertions, double fpp) {
            super(expectedInsertions, fpp);
        }

        CircuitBreakerLongBloomFilter(LongBloomFilter.BitArray bits, int numHashFunctions, LongBloomFilter.Hashing hashing) {
            super(bits, numHashFunctions, hashing);
        }

        @Override
        protected LongBloomFilter.BitArray createBitArray(long numBits) {
            int memSize = Ints.checkedCast((long)LongMath.divide((long)numBits, (long)64L, (RoundingMode)RoundingMode.CEILING)) * 8;
            BloomFilterTermsSet.this.breaker.addEstimateBytesAndMaybeBreak((long)memSize, "<terms_set>");
            try {
                return new LongBloomFilter.BitArray(numBits);
            }
            catch (OutOfMemoryError e) {
                BloomFilterTermsSet.this.breaker.addWithoutBreaking((long)(-memSize));
                throw e;
            }
        }

        @Override
        protected void release() {
            int memSize = this.bits.data.length * 8;
            super.release();
            BloomFilterTermsSet.this.breaker.addWithoutBreaking((long)(-memSize));
        }
    }
}

